/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.utils.Tags;
import eu.europeana.cloud.mcs.driver.MCSClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.mcs.driver.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionServiceClient
extends MCSClient {
    private final Client client;
    private static final Logger logger = LoggerFactory.getLogger(RevisionServiceClient.class);
    private static final String revisionPathWithTag = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/revisions/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}/tag/{TAG}";
    private static final String revisionPath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/revisions";
    private static final String revisionPathWithMultipleTags = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/revisions/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}/tags";

    public RevisionServiceClient(String baseUrl) {
        super(baseUrl);
        this.client = (Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class);
    }

    public RevisionServiceClient(String baseUrl, String username, String password) {
        super(baseUrl);
        this.client = (Client)((Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class)).register(HttpAuthenticationFeature.basicBuilder().credentials(username, password).build());
    }

    public void useAuthorizationHeader(String headerValue) {
        this.client.register(new ECloudBasicAuthFilter(headerValue));
    }

    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, String tag) throws DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(revisionPathWithTag).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("REVISION_NAME", revisionName).resolveTemplate("REVISION_PROVIDER_ID", revisionProviderId).resolveTemplate("TAG", tag);
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(null);
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                URI uRI = response.getLocation();
                return uRI;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public URI addRevision(String cloudId, String representationName, String version, Revision revision) throws DriverException, MCSException {
        Response response;
        block3: {
            WebTarget target = this.client.target(this.baseUrl).path(revisionPath).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version);
            Invocation.Builder request = target.request();
            response = null;
            try {
                response = request.accept("application/json").post(Entity.json(revision));
                if (response.getStatus() != Response.Status.CREATED.getStatusCode()) break block3;
                URI uRI = response.getLocation();
                this.closeResponse(response);
                return uRI;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                throw throwable;
            }
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI addRevision(String cloudId, String representationName, String version, String revisionName, String revisionProviderId, Set<Tags> tags) throws DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(revisionPathWithMultipleTags).resolveTemplate("CLOUDID", cloudId).resolveTemplate("REPRESENTATIONNAME", representationName).resolveTemplate("VERSION", version).resolveTemplate("REVISION_NAME", revisionName).resolveTemplate("REVISION_PROVIDER_ID", revisionProviderId);
        Form tagsForm = new Form();
        for (Tags tag : tags) {
            tagsForm.param("tags", tag.getTag());
        }
        Invocation.Builder request = target.request();
        Response response = null;
        try {
            response = request.post(Entity.form(tagsForm));
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                URI uRI = response.getLocation();
                return uRI;
            }
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        finally {
            this.closeResponse(response);
        }
    }

    private void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }
}

