/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model.dps;

import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TaskInfo {
    private final long id;
    private final String topologyName;
    private int containsElements;
    private TaskState state;
    private String info;
    private Date finishDate;
    private Date startDate;
    private Date sentDate;
    private List<SubTaskInfo> subtasks = new ArrayList<SubTaskInfo>();

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public TaskInfo(long id, String topologyName, TaskState state, String info, Date sentDate, Date startDate, Date finishDate) {
        this.id = id;
        this.topologyName = topologyName;
        this.state = state;
        this.info = info;
        this.sentDate = sentDate;
        this.startDate = startDate;
        this.finishDate = finishDate;
    }

    public long getId() {
        return this.id;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public int getContainsElements() {
        return this.containsElements;
    }

    public void setContainsElements(int containsElements) {
        this.containsElements = containsElements;
    }

    public List<SubTaskInfo> getSubtasks() {
        return Collections.unmodifiableList(this.subtasks);
    }

    public void addSubtask(SubTaskInfo subtask) {
        this.subtasks.add(subtask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo taskInfo = (TaskInfo)o;
        if (this.containsElements != taskInfo.containsElements) {
            return false;
        }
        if (this.id != taskInfo.id) {
            return false;
        }
        if (this.subtasks != null ? !this.subtasks.equals(taskInfo.subtasks) : taskInfo.subtasks != null) {
            return false;
        }
        if (this.topologyName != null ? !this.topologyName.equals(taskInfo.topologyName) : taskInfo.topologyName != null) {
            return false;
        }
        if (this.state != taskInfo.state) {
            return false;
        }
        if (this.startDate == null && taskInfo.startDate != null) {
            return false;
        }
        if (this.startDate != null && taskInfo.startDate != null && this.startDate.getTime() != taskInfo.startDate.getTime()) {
            return false;
        }
        if (this.sentDate == null && taskInfo.sentDate != null) {
            return false;
        }
        if (this.sentDate != null && taskInfo.sentDate != null && this.sentDate.getTime() != taskInfo.sentDate.getTime()) {
            return false;
        }
        if (this.finishDate == null && taskInfo.finishDate != null) {
            return false;
        }
        return this.finishDate == null || taskInfo.finishDate == null || this.finishDate.getTime() == taskInfo.finishDate.getTime();
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.topologyName != null ? this.topologyName.hashCode() : 0);
        result = 31 * result + this.containsElements;
        result = 31 * result + (this.subtasks != null ? this.subtasks.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.sentDate != null ? this.sentDate.hashCode() : 0);
        return result;
    }
}

