/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.Permission;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.filter.ECloudBasicAuthFilter;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.CannotPersistEmptyRepresentationException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.status.McsErrorCode;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordServiceClient {
    private final String baseUrl;
    private final Client client = ClientBuilder.newClient();
    private static final Logger logger = LoggerFactory.getLogger(DataSetServiceClient.class);
    private static final String recordPath;
    private static final String representationsPath;
    private static final String represtationNamePath;
    private static final String versionsPath;
    private static final String versionPath;
    private static final String copyPath;
    private static final String persistPath;
    private static final String grantingPermissionsToVesionPath;
    private static final String permitPath;

    public RecordServiceClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public RecordServiceClient(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl;
        this.client.register((Object)new HttpBasicAuthFilter(username, password));
    }

    public RecordServiceClient useAuthorizationHeader(String headerValue) {
        this.client.register((Object)new ECloudBasicAuthFilter(headerValue));
        return this;
    }

    public Record getRecord(String cloudId) throws RecordNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(recordPath).resolveTemplate("CLOUDID", (Object)cloudId);
        Invocation.Builder request = target.request();
        Response response = request.get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (Record)response.readEntity(Record.class);
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public void deleteRecord(String cloudId) throws RecordNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(recordPath).resolveTemplate("CLOUDID", (Object)cloudId);
        Invocation.Builder request = target.request();
        Response response = request.delete();
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public List<Representation> getRepresentations(String cloudId) throws RecordNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(representationsPath).resolveTemplate("CLOUDID", (Object)cloudId);
        Response response = target.request().get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return (List)response.readEntity((GenericType)new GenericType<List<Representation>>(){});
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public Representation getRepresentation(String cloudId, String representationName) throws RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(represtationNamePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName);
        Invocation.Builder request = target.request();
        Response response = request.get();
        if (response.getStatus() == Response.Status.OK.getStatusCode() || response.getStatus() == Response.Status.TEMPORARY_REDIRECT.getStatusCode()) {
            Representation representation = (Representation)response.readEntity(Representation.class);
            return representation;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI createRepresentation(String cloudId, String representationName, String providerId) throws ProviderNotExistsException, RecordNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(represtationNamePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName);
        Invocation.Builder request = target.request();
        Form form = new Form();
        form.param("providerId", providerId);
        Response response = request.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            URI uri = response.getLocation();
            return uri;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public void deleteRepresentation(String cloudId, String representationName) throws RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(represtationNamePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName);
        Invocation.Builder request = target.request();
        Response response = request.delete();
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public List<Representation> getRepresentations(String cloudId, String representationName) throws RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(versionsPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName);
        Invocation.Builder request = target.request();
        Response response = request.get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            List list = (List)response.readEntity((GenericType)new GenericType<List<Representation>>(){});
            return list;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public Representation getRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path(versionPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        Invocation.Builder request = webtarget.request();
        Response response = request.get();
        System.out.println(response);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            Representation representation = (Representation)response.readEntity(Representation.class);
            return representation;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public void deleteRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, MCSException {
        WebTarget webtarget = this.client.target(this.baseUrl).path(versionPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        Invocation.Builder request = webtarget.request();
        Response response = request.delete();
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public URI copyRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(copyPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        Invocation.Builder request = target.request();
        Response response = request.post(Entity.entity((Object)new Form(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI persistRepresentation(String cloudId, String representationName, String version) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, CannotPersistEmptyRepresentationException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(persistPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        Form form = new Form();
        Invocation.Builder request = target.request();
        Response response = request.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            URI uri = response.getLocation();
            return uri;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public void grantPermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(grantingPermissionsToVesionPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("PERMISSION_TYPE", (Object)permission.getValue()).resolveTemplate("USERNAME", (Object)userName);
        Invocation.Builder request = target.request();
        Response response = request.post(null);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            this.throwException(response);
        }
    }

    public void revokePermissionsToVersion(String cloudId, String representationName, String version, String userName, Permission permission) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(grantingPermissionsToVesionPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("PERMISSION_TYPE", (Object)permission.getValue()).resolveTemplate("USERNAME", (Object)userName);
        Invocation.Builder request = target.request();
        Response response = request.delete();
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public void permitVersion(String cloudId, String representationName, String version) throws MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(permitPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        Invocation.Builder request = target.request();
        Response response = request.post(null);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            this.throwException(response);
        }
    }

    private void throwException(Response response) throws MCSException {
        try {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
        catch (MessageBodyProviderNotFoundException e) {
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.setErrorCode(McsErrorCode.OTHER.toString());
            errorInfo.setDetails("Mcs not available");
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("records");
        builder.append("/");
        builder.append("{");
        builder.append("CLOUDID");
        builder.append("}");
        recordPath = builder.toString();
        builder.append("/");
        builder.append("representations");
        representationsPath = builder.toString();
        builder.append("/");
        builder.append("{");
        builder.append("REPRESENTATIONNAME");
        builder.append("}");
        represtationNamePath = builder.toString();
        builder.append("/");
        builder.append("versions");
        versionsPath = builder.toString();
        builder.append("/");
        builder.append("{");
        builder.append("VERSION");
        builder.append("}");
        versionPath = builder.toString();
        copyPath = versionPath + "/" + "copy";
        persistPath = versionPath + "/" + "persist";
        permitPath = versionPath + "/" + "permit";
        grantingPermissionsToVesionPath = versionPath + "/permissions/{" + "PERMISSION_TYPE" + "}/users/{" + "USERNAME" + "}";
    }
}

