/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.MethodHandler;

class PushMethodHandlerRouter
implements Router {
    private final ServiceLocator locator;
    private final Provider<RoutingContext> routingContextFactory;
    private final MethodHandler methodHandler;
    private final Router next;

    private PushMethodHandlerRouter(Provider<RoutingContext> routingContextFactory, ServiceLocator locator, MethodHandler methodHandler, Router next) {
        this.locator = locator;
        this.routingContextFactory = routingContextFactory;
        this.methodHandler = methodHandler;
        this.next = next;
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        Object storedResource = this.routingContextFactory.get().peekMatchedResource();
        if (storedResource == null || !storedResource.getClass().equals(this.methodHandler.getHandlerClass())) {
            Object handlerInstance = this.methodHandler.getInstance(this.locator);
            this.routingContextFactory.get().pushMatchedResource(handlerInstance);
        }
        return Router.Continuation.of(request, this.next);
    }

    static class Builder {
        @Inject
        private Provider<RoutingContext> routingContextFactory;
        @Inject
        private ServiceLocator locator;

        Builder() {
        }

        public PushMethodHandlerRouter build(MethodHandler methodHandler, Router next) {
            return new PushMethodHandlerRouter(this.routingContextFactory, this.locator, methodHandler, next);
        }
    }
}

