/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.common.utils.FirstFlag;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RepresentationIterator
implements Iterator<Representation> {
    private final DataSetServiceClient client;
    private final String providerId;
    private final String dataSetId;
    private FirstFlag firstTime = new FirstFlag();
    private String nextSlice = null;
    private Iterator<Representation> representationListIterator;

    public RepresentationIterator(DataSetServiceClient client, String providerId, String dataSetId) {
        if (client == null) {
            throw new DriverException("DataSetServiceClient for RepresentationIterator cannot be null");
        }
        this.client = client;
        if (providerId == null || providerId.equals("")) {
            throw new DriverException("ProviderId for RepresentationIterator cannot be null/empty");
        }
        this.providerId = providerId;
        if (dataSetId == null || dataSetId.equals("")) {
            throw new DriverException("ProviderId for RepresentationIterator cannot be null/empty");
        }
        this.dataSetId = dataSetId;
    }

    @Override
    public boolean hasNext() {
        if (this.firstTime.unpack().booleanValue()) {
            this.obtainNextChunk();
        }
        return this.representationListIterator.hasNext() || this.nextSlice != null;
    }

    @Override
    public Representation next() {
        if (this.firstTime.unpack().booleanValue()) {
            this.obtainNextChunk();
        }
        if (this.representationListIterator.hasNext()) {
            return this.representationListIterator.next();
        }
        if (this.nextSlice != null) {
            this.obtainNextChunk();
            return this.representationListIterator.next();
        }
        throw new NoSuchElementException("Calling next on exhausted Representation iterator.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private void obtainNextChunk() {
        ResultSlice<Representation> currentChunk;
        try {
            currentChunk = this.client.getDataSetRepresentationsChunk(this.providerId, this.dataSetId, this.nextSlice);
        }
        catch (DataSetNotExistsException ex) {
            throw new DriverException("Data set does not exist.", (Exception)((Object)ex));
        }
        catch (MCSException ex) {
            throw new DriverException("Error when trying to obtain Representation list chunk for iterator", (Exception)((Object)ex));
        }
        this.representationListIterator = currentChunk.getResults().iterator();
        this.nextSlice = currentChunk.getNextSlice();
    }
}

