/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceClient {
    private final Client client;
    private final String baseUrl;
    private static final Logger logger = LoggerFactory.getLogger(FileServiceClient.class);
    private static final String filesPath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files";
    private static final String filePath = "records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/files/{FILENAME}";

    public FileServiceClient(String baseUrl) {
        this.client = (Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class);
        this.baseUrl = baseUrl;
    }

    public FileServiceClient(String baseUrl, String username, String password) {
        this.client = (Client)((Client)JerseyClientBuilder.newClient().register(MultiPartFeature.class)).register((Object)new HttpBasicAuthFilter(username, password));
        this.baseUrl = baseUrl;
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("FILENAME", (Object)fileName);
        Invocation.Builder requset = target.request();
        Response response = requset.get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            InputStream contentResponse = (InputStream)response.readEntity(InputStream.class);
            return contentResponse;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public InputStream getFile(String cloudId, String representationName, String version, String fileName, String range) throws RepresentationNotExistsException, FileNotExistsException, WrongContentRangeException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("FILENAME", (Object)fileName);
        Invocation.Builder requset = target.request().header("Range", (Object)range);
        Response response = requset.get();
        if (response.getStatus() == Response.Status.PARTIAL_CONTENT.getStatusCode()) {
            InputStream contentResponse = (InputStream)response.readEntity(InputStream.class);
            return contentResponse;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public InputStream getFile(String fileUrl) throws RepresentationNotExistsException, FileNotExistsException, WrongContentRangeException, DriverException, MCSException, IOException {
        Response response = this.client.target(fileUrl).request().get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            InputStream contentResponse = (InputStream)response.readEntity(InputStream.class);
            return contentResponse;
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String expectedMd5) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Invocation.Builder request = target.request();
        Response response = request.post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            if (!expectedMd5.equals(response.getEntityTag().getValue())) {
                throw new IOException("Incorrect MD5 checksum");
            }
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String cloudId, String representationName, String version, InputStream data, String mediaType) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filesPath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version);
        FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Invocation.Builder request = target.request();
        Response response = request.post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI uploadFile(String versionUrl, InputStream data, String mediaType) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        String filesPath = "/files";
        FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Response response = this.client.target(versionUrl + filesPath).request().post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI modyfiyFile(String cloudId, String representationName, String version, InputStream data, String mediaType, String fileName, String expectedMd5) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("FILENAME", (Object)fileName);
        FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Response response = target.request().put(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            if (!expectedMd5.equals(response.getEntityTag().getValue())) {
                throw new IOException("Incorrect MD5 checksum");
            }
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public URI modifyFile(String fileUrl, InputStream data, String mediaType) throws IOException, RepresentationNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        WebTarget target = this.client.target(fileUrl);
        FormDataMultiPart multipart = new FormDataMultiPart().field("mimeType", mediaType).field("data", (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        Response response = target.request().put(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public void deleteFile(String cloudId, String representationName, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException, CannotModifyPersistentRepresentationException, DriverException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("FILENAME", (Object)fileName);
        Response response = target.request().delete();
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = (ErrorInfo)response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public URI getFileUri(String cloudId, String representationName, String version, String fileName) {
        WebTarget target = this.client.target(this.baseUrl).path(filePath).resolveTemplate("CLOUDID", (Object)cloudId).resolveTemplate("REPRESENTATIONNAME", (Object)representationName).resolveTemplate("VERSION", (Object)version).resolveTemplate("FILENAME", (Object)fileName);
        return target.getUri();
    }

    public static Map<String, String> parseFileUri(String uri) {
        Pattern p = Pattern.compile(".*/records/([^/]+)/representations/([^/]+)/versions/([^/]+)/files/*([^/]+)*.*");
        Matcher m = p.matcher(uri);
        if (m.find()) {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put("CLOUDID", m.group(1));
            ret.put("REPRESENTATIONNAME", m.group(2));
            ret.put("VERSION", m.group(3));
            ret.put("FILENAME", m.group(4));
            return ret;
        }
        return null;
    }
}

