/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs;

import java.util.Date;
import java.util.Objects;

public final class RepresentationSearchParams {
    private final String recordId;
    private final String schema;
    private final String dataProvider;
    private final Boolean persistent;
    private final String dataSetId;
    private final String dataSetProviderId;
    private final Date fromDate;
    private final Date toDate;

    private RepresentationSearchParams(String recordId, String schema, String dataProvider, Boolean persistent, String dataSetId, String dataSetProviderId, Date fromDate, Date toDate) {
        this.recordId = recordId;
        this.schema = schema;
        this.dataProvider = dataProvider;
        this.persistent = persistent;
        this.dataSetId = dataSetId;
        this.dataSetProviderId = dataSetProviderId;
        this.fromDate = fromDate != null ? fromDate : null;
        this.toDate = toDate != null ? toDate : null;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDataProvider() {
        return this.dataProvider;
    }

    public Boolean isPersistent() {
        return this.persistent;
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public String getDataSetProviderId() {
        return this.dataSetProviderId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + Objects.hashCode(this.recordId);
        hash = 11 * hash + Objects.hashCode(this.schema);
        hash = 11 * hash + Objects.hashCode(this.dataProvider);
        hash = 11 * hash + Objects.hashCode(this.persistent);
        hash = 11 * hash + Objects.hashCode(this.dataSetId);
        hash = 11 * hash + Objects.hashCode(this.dataSetProviderId);
        hash = 11 * hash + Objects.hashCode(this.fromDate);
        hash = 11 * hash + Objects.hashCode(this.toDate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepresentationSearchParams other = (RepresentationSearchParams)obj;
        if (!Objects.equals(this.recordId, other.recordId)) {
            return false;
        }
        if (!Objects.equals(this.schema, other.schema)) {
            return false;
        }
        if (!Objects.equals(this.dataProvider, other.dataProvider)) {
            return false;
        }
        if (!Objects.equals(this.persistent, other.persistent)) {
            return false;
        }
        if (!Objects.equals(this.dataSetId, other.dataSetId)) {
            return false;
        }
        if (!Objects.equals(this.dataSetProviderId, other.dataSetProviderId)) {
            return false;
        }
        if (!Objects.equals(this.fromDate, other.fromDate)) {
            return false;
        }
        return Objects.equals(this.toDate, other.toDate);
    }

    public String toString() {
        return "RepresentationSearchParams{recordId=" + this.recordId + ", schema=" + this.schema + ", dataProvider=" + this.dataProvider + ", persistent=" + this.persistent + ", dataSetId=" + this.dataSetId + ", dataSetProviderId=" + this.dataSetProviderId + ", fromDate=" + this.fromDate + ", toDate=" + this.toDate + '}';
    }

    public static class Builder {
        private String recordId;
        private String schema;
        private String dataProvider;
        private Boolean persistent;
        private String dataSetId;
        private String dataSetProviderId;
        private Date fromDate;
        private Date toDate;

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder setDataProvider(String dataProvider) {
            this.dataProvider = dataProvider;
            return this;
        }

        public Builder setPersistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder setRecordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public Builder setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public Builder setDataSetProviderId(String dataSetProviderId) {
            this.dataSetProviderId = dataSetProviderId;
            return this;
        }

        public Builder setFromDate(Date fromDate) {
            this.fromDate = fromDate != null ? fromDate : null;
            return this;
        }

        public Builder setToDate(Date toDate) {
            this.toDate = toDate != null ? toDate : null;
            return this;
        }

        public RepresentationSearchParams build() {
            return new RepresentationSearchParams(this.recordId, this.schema, this.dataProvider, this.persistent, this.dataSetId, this.dataSetProviderId, this.fromDate, this.toDate);
        }
    }
}

