/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.mcs.driver;

import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.mcs.driver.DataSetIterator;
import eu.europeana.cloud.mcs.driver.MCSExceptionProvider;
import eu.europeana.cloud.mcs.driver.RepresentationIterator;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.DataSetAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetServiceClient {
    private final String baseUrl;
    private final Client client = ClientBuilder.newClient();
    private static final Logger logger = LoggerFactory.getLogger(DataSetServiceClient.class);
    private static final String dataSetsPath;
    private static final String dataSetPath;
    private static final String assignmentsPath;

    public DataSetServiceClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public DataSetServiceClient(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl;
        this.client.register(new HttpBasicAuthFilter(username, password));
    }

    public ResultSlice<DataSet> getDataSetsForProviderChunk(String providerId, String startFrom) throws MCSException {
        Response response;
        WebTarget target = this.client.target(this.baseUrl).path(dataSetsPath).resolveTemplate("DATAPROVIDER", providerId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", startFrom);
        }
        if ((response = target.request().get()).getStatus() == Response.Status.OK.getStatusCode()) {
            return response.readEntity(ResultSlice.class);
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public List<DataSet> getDataSetsForProvider(String providerId) throws MCSException {
        ResultSlice<DataSet> resultSlice;
        ArrayList<DataSet> resultList = new ArrayList<DataSet>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetsForProviderChunk(providerId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public DataSetIterator getDataSetIteratorForProvider(String providerId) {
        return new DataSetIterator(this, providerId);
    }

    public URI createDataSet(String providerId, String dataSetId, String description) throws ProviderNotExistsException, DataSetAlreadyExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetsPath).resolveTemplate("DATAPROVIDER", providerId);
        Form form = new Form();
        form.param("dataSetId", dataSetId);
        form.param("description", description);
        Response response = target.request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return response.getLocation();
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public ResultSlice<Representation> getDataSetRepresentationsChunk(String providerId, String dataSetId, String startFrom) throws DataSetNotExistsException, MCSException {
        Response response;
        WebTarget target = this.client.target(this.baseUrl).path(dataSetPath).resolveTemplate("DATAPROVIDER", providerId).resolveTemplate("DATASET", dataSetId);
        if (startFrom != null) {
            target = target.queryParam("startFrom", startFrom);
        }
        if ((response = target.request().get()).getStatus() == Response.Status.OK.getStatusCode()) {
            return response.readEntity(ResultSlice.class);
        }
        ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
        throw MCSExceptionProvider.generateException(errorInfo);
    }

    public List<Representation> getDataSetRepresentations(String providerId, String dataSetId) throws DataSetNotExistsException, MCSException {
        ResultSlice<Representation> resultSlice;
        ArrayList<Representation> resultList = new ArrayList<Representation>();
        String startFrom = null;
        do {
            if ((resultSlice = this.getDataSetRepresentationsChunk(providerId, dataSetId, startFrom)) == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting DataSet: result chunk obtained but is empty.");
            }
            resultList.addAll(resultSlice.getResults());
            startFrom = resultSlice.getNextSlice();
        } while (resultSlice.getNextSlice() != null);
        return resultList;
    }

    public RepresentationIterator getRepresentationIterator(String providerId, String dataSetId) {
        return new RepresentationIterator(this, providerId, dataSetId);
    }

    public void updateDescriptionOfDataSet(String providerId, String dataSetId, String description) throws DataSetNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetPath).resolveTemplate("DATAPROVIDER", providerId).resolveTemplate("DATASET", dataSetId);
        Form form = new Form();
        form.param("description", description);
        Response response = target.request().put(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public void deleteDataSet(String providerId, String dataSetId) throws DataSetNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(dataSetPath).resolveTemplate("DATAPROVIDER", providerId).resolveTemplate("DATASET", dataSetId);
        Response response = target.request().delete();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public void assignRepresentationToDataSet(String providerId, String dataSetId, String cloudId, String representationName, String versionId) throws DataSetNotExistsException, RepresentationNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(assignmentsPath).resolveTemplate("DATAPROVIDER", providerId).resolveTemplate("DATASET", dataSetId);
        Form form = new Form();
        form.param("cloudId", cloudId);
        form.param("representationName", representationName);
        form.param("version", versionId);
        Response response = target.request().post(Entity.entity(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    public void unassignRepresentationFromDataSet(String providerId, String dataSetId, String cloudId, String representationName) throws DataSetNotExistsException, MCSException {
        WebTarget target = this.client.target(this.baseUrl).path(assignmentsPath).resolveTemplate("DATAPROVIDER", providerId).resolveTemplate("DATASET", dataSetId).queryParam("cloudId", cloudId).queryParam("representationName", representationName);
        Response response = target.request().delete();
        if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            ErrorInfo errorInfo = response.readEntity(ErrorInfo.class);
            throw MCSExceptionProvider.generateException(errorInfo);
        }
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("data-providers");
        builder.append("/");
        builder.append("{");
        builder.append("DATAPROVIDER");
        builder.append("}/");
        builder.append("data-sets");
        dataSetsPath = builder.toString();
        builder.append("/");
        builder.append("{");
        builder.append("DATASET");
        builder.append("}");
        dataSetPath = builder.toString();
        builder.append("/");
        builder.append("assignments");
        assignmentsPath = builder.toString();
    }
}

