/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.uis;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.mcs.UISClientHandler;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.persistent.exception.SystemException;
import eu.europeana.cloud.service.uis.exception.CloudIdDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;
import org.springframework.beans.factory.annotation.Autowired;

public class UISClientHandlerImpl
implements UISClientHandler {
    @Autowired
    private UISClient uisClient;

    public boolean existsCloudId(String cloudId) {
        boolean result = false;
        try {
            ResultSlice records = this.uisClient.getRecordId(cloudId);
            if (records == null) {
                throw new IllegalStateException("UIS returned null");
            }
            if (records.getResults().isEmpty()) {
                throw new IllegalStateException("UIS returned empty list");
            }
            for (CloudId ci : records.getResults()) {
                if (!ci.getId().equals(cloudId)) continue;
                result = true;
                break;
            }
            if (!result) {
                throw new IllegalStateException(String.format("Cloud id %s not on the list returned by UIS", cloudId));
            }
        }
        catch (CloudException ex) {
            if (ex.getCause() instanceof CloudIdDoesNotExistException) {
                result = false;
            }
            throw new SystemException(ex);
        }
        return result;
    }

    public CloudId getCloudIdFromProviderAndLocalId(String providerId, String localId) throws ProviderNotExistsException, RecordNotExistsException {
        try {
            return this.uisClient.getCloudId(providerId, localId);
        }
        catch (CloudException ex) {
            if (ex.getCause() instanceof RecordDoesNotExistException) {
                throw new RecordNotExistsException(localId, providerId);
            }
            if (ex.getCause() instanceof ProviderDoesNotExistException) {
                throw new ProviderNotExistsException(ex.getMessage());
            }
            throw new SystemException(ex);
        }
    }

    public boolean existsProvider(String providerId) {
        DataProvider result;
        try {
            result = this.uisClient.getDataProvider(providerId);
        }
        catch (CloudException e) {
            if (e.getCause() instanceof ProviderDoesNotExistException) {
                result = null;
            }
            throw new SystemException(e);
        }
        return result != null;
    }

    public DataProvider getProvider(String providerId) {
        DataProvider result;
        try {
            result = this.uisClient.getDataProvider(providerId);
        }
        catch (CloudException e) {
            if (e.getCause() instanceof ProviderDoesNotExistException) {
                return null;
            }
            throw new SystemException(e);
        }
        return result;
    }
}

