/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.swift;

import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import eu.europeana.cloud.service.mcs.exception.FileAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.persistent.swift.ContentDAO;
import eu.europeana.cloud.service.mcs.persistent.swift.PutResult;
import eu.europeana.cloud.service.mcs.persistent.swift.SwiftConnectionProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.io.Payload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SwiftContentDAO
implements ContentDAO {
    @Autowired
    private SwiftConnectionProvider connectionProvider;

    @Override
    public PutResult putContent(String fileName, InputStream data) throws IOException, ContainerNotFoundException {
        BlobStore blobStore = this.connectionProvider.getBlobStore();
        String container = this.connectionProvider.getContainer();
        CountingInputStream countingInputStream = new CountingInputStream(data);
        DigestInputStream md5DigestInputStream = this.md5InputStream((InputStream)countingInputStream);
        BlobBuilder builder = blobStore.blobBuilder(fileName);
        builder = builder.name(fileName);
        builder = builder.payload((InputStream)md5DigestInputStream);
        Blob blob = builder.build();
        blobStore.putBlob(container, blob);
        String md5 = BaseEncoding.base16().lowerCase().encode(md5DigestInputStream.getMessageDigest().digest());
        Long contentLength = countingInputStream.getCount();
        return new PutResult(md5, contentLength);
    }

    @Override
    public void getContent(String fileName, long start, long end, OutputStream os) throws IOException, FileNotExistsException, ContainerNotFoundException {
        BlobStore blobStore = this.connectionProvider.getBlobStore();
        String container = this.connectionProvider.getContainer();
        if (!blobStore.blobExists(this.connectionProvider.getContainer(), fileName)) {
            throw new FileNotExistsException(String.format("File %s not exists", fileName));
        }
        GetOptions options = GetOptions.NONE;
        if (start > -1L && end > -1L) {
            options = new GetOptions().range(start, end);
        } else if (start > -1L && end == -1L) {
            options = new GetOptions().startAt(start);
        } else if (start == -1L && end > -1L) {
            options = new GetOptions().range(0L, end);
        }
        Payload payload = blobStore.getBlob(container, fileName, options).getPayload();
        if (payload != null) {
            ByteStreams.copy((InputStream)payload.getInput(), (OutputStream)os);
        }
    }

    @Override
    public void copyContent(String sourceObjectId, String trgObjectId) throws FileNotExistsException, FileAlreadyExistsException {
        BlobStore blobStore = this.connectionProvider.getBlobStore();
        String container = this.connectionProvider.getContainer();
        if (!blobStore.blobExists(this.connectionProvider.getContainer(), sourceObjectId)) {
            throw new FileNotExistsException(String.format("File %s not exists", sourceObjectId));
        }
        if (blobStore.blobExists(this.connectionProvider.getContainer(), trgObjectId)) {
            throw new FileAlreadyExistsException(String.format("Target file %s already exists", trgObjectId));
        }
        Blob blob = blobStore.getBlob(container, sourceObjectId);
        Blob newBlob = blobStore.blobBuilder(trgObjectId).name(trgObjectId).payload(blob.getPayload()).build();
        blobStore.putBlob(container, newBlob);
    }

    @Override
    public void deleteContent(String fileName) throws FileNotExistsException {
        BlobStore blobStore = this.connectionProvider.getBlobStore();
        String container = this.connectionProvider.getContainer();
        if (!blobStore.blobExists(this.connectionProvider.getContainer(), fileName)) {
            throw new FileNotExistsException(String.format("File %s not exists", fileName));
        }
        blobStore.removeBlob(container, fileName);
    }

    private DigestInputStream md5InputStream(InputStream is) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return new DigestInputStream(is, md);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError("Cannot get instance of MD5 but such algorithm should be provided", ex);
        }
    }
}

