/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.swift;

import eu.europeana.cloud.service.mcs.persistent.swift.SwiftConnectionProvider;
import java.util.NoSuchElementException;
import javax.annotation.PreDestroy;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SimpleSwiftConnectionProvider
implements SwiftConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSwiftConnectionProvider.class);
    private BlobStoreContext context;
    private final String container;
    private BlobStore blobStore;
    private final String provider;
    private final String endpoint;
    private final String user;
    private final String password;

    public SimpleSwiftConnectionProvider(String provider, String container, String endpoint, String user, String password) {
        this.container = container;
        this.provider = provider;
        this.endpoint = endpoint;
        this.user = user;
        this.password = password;
        this.openConnections();
    }

    private void openConnections() throws NoSuchElementException {
        this.context = (BlobStoreContext)ContextBuilder.newBuilder((String)this.provider).endpoint(this.endpoint).credentials(this.user, this.password).buildView(BlobStoreContext.class);
        this.blobStore = this.context.getBlobStore();
        if (!this.blobStore.containerExists(this.container)) {
            this.blobStore.createContainerInLocation(null, this.container);
        }
        LOGGER.info("Connected to swift.");
    }

    @Override
    public void reconnectConnections() {
        this.closeConnections();
        this.openConnections();
    }

    @Override
    @PreDestroy
    public void closeConnections() {
        LOGGER.info("Shutting down swift connection");
        this.context.close();
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public BlobStore getBlobStore() {
        return this.blobStore;
    }
}

