/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.swift;

import java.util.Iterator;

public class RandomIterator<T>
implements Iterator<T> {
    private final Iterator<T> internalIterator;
    private final double switchProbability;
    private T prevoutsValue;

    public RandomIterator(Iterator<T> internalIterator, double switchProbability) {
        if (!(switchProbability > 0.0) || !(switchProbability < 1.0)) {
            throw new RuntimeException("switchProbability should be number in range (0.0 - 1.0)");
        }
        this.internalIterator = internalIterator;
        this.switchProbability = switchProbability;
    }

    @Override
    public boolean hasNext() {
        return this.internalIterator.hasNext();
    }

    @Override
    public T next() {
        if (Math.random() > this.switchProbability || this.prevoutsValue == null) {
            this.prevoutsValue = this.internalIterator.next();
        }
        return this.prevoutsValue;
    }

    @Override
    public void remove() {
        this.internalIterator.remove();
    }
}

