/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.swift;

import eu.europeana.cloud.service.mcs.persistent.swift.DBlobStore;
import eu.europeana.cloud.service.mcs.persistent.swift.SimpleSwiftConnectionProvider;
import eu.europeana.cloud.service.mcs.persistent.swift.SwiftConnectionProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jclouds.blobstore.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicSwiftConnectionProvider
implements SwiftConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSwiftConnectionProvider.class);
    private final List<SwiftConnectionProvider> proxys;
    private List<BlobStore> blobStores;
    @Autowired
    private DBlobStore dynamicBlobStore;
    private final String container;

    public DynamicSwiftConnectionProvider(String provider, String container, String endpointsList, String user, String password) {
        String[] endpoints = endpointsList.split(",");
        this.proxys = new ArrayList<SwiftConnectionProvider>();
        this.blobStores = new ArrayList<BlobStore>();
        this.container = container;
        for (String endpoint : endpoints) {
            LOGGER.info("Connecing to swift" + endpoint);
            SimpleSwiftConnectionProvider connectionProvider = new SimpleSwiftConnectionProvider(provider, container, endpoint, user, password);
            this.blobStores.add(connectionProvider.getBlobStore());
            this.proxys.add(connectionProvider);
        }
    }

    @PostConstruct
    public void setBlobStores() {
        this.dynamicBlobStore.setBlobStores(this.blobStores);
    }

    @Override
    @PreDestroy
    public void closeConnections() {
        for (SwiftConnectionProvider proxy : this.proxys) {
            proxy.closeConnections();
        }
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public BlobStore getBlobStore() {
        return this.dynamicBlobStore;
    }

    @Override
    public void reconnectConnections() {
        this.blobStores = new ArrayList<BlobStore>();
        for (SwiftConnectionProvider proxy : this.proxys) {
            LOGGER.info("Reconnect to swift" + proxy);
            proxy.reconnectConnections();
            this.blobStores.add(proxy.getBlobStore());
        }
        this.setBlobStores();
    }
}

