/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.swift;

import com.google.common.collect.Iterators;
import eu.europeana.cloud.service.mcs.persistent.swift.DBlobStore;
import eu.europeana.cloud.service.mcs.persistent.swift.RandomIterator;
import eu.europeana.cloud.service.mcs.persistent.swift.RetryOnFailure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;

public class DynamicBlobStore
implements DBlobStore {
    private List<BlobStore> blobStores;
    private BlobStore activeInstance;
    private Iterator<BlobStore> blobIterator;

    public DynamicBlobStore() {
    }

    protected DynamicBlobStore(List<BlobStore> blobStores, Iterator<BlobStore> blobIterator) {
        this.blobStores = blobStores;
        this.blobIterator = blobIterator;
    }

    @Override
    public DynamicBlobStore getDynamicBlobStoreWithoutActiveInstance() {
        ArrayList<BlobStore> bStore = new ArrayList<BlobStore>(this.blobStores);
        bStore.remove(this.activeInstance);
        Iterator iterator = Iterators.cycle(bStore);
        return new DynamicBlobStore(bStore, iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobStores(List<BlobStore> blobStores) {
        DynamicBlobStore dynamicBlobStore = this;
        synchronized (dynamicBlobStore) {
            this.blobStores = blobStores;
            this.blobIterator = new RandomIterator<BlobStore>(Iterators.cycle(blobStores), 0.5);
        }
    }

    @Override
    public int getInstanceNumber() {
        return this.blobStores.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchInstance() {
        DynamicBlobStore dynamicBlobStore = this;
        synchronized (dynamicBlobStore) {
            this.activeInstance = this.blobIterator.next();
        }
    }

    private BlobStore getActiveInstance() {
        this.switchInstance();
        return this.activeInstance;
    }

    public BlobStoreContext getContext() {
        return this.getActiveInstance().getContext();
    }

    @RetryOnFailure
    public boolean blobExists(String container, String name) {
        return this.getActiveInstance().blobExists(container, name);
    }

    @RetryOnFailure
    public BlobBuilder blobBuilder(String name) {
        return this.getActiveInstance().blobBuilder(name);
    }

    @RetryOnFailure
    public String putBlob(String container, Blob blob) {
        return this.getActiveInstance().putBlob(container, blob);
    }

    @RetryOnFailure
    public Blob getBlob(String container, String name) {
        return this.getActiveInstance().getBlob(container, name);
    }

    @RetryOnFailure
    public Blob getBlob(String container, String name, GetOptions options) {
        return this.getActiveInstance().getBlob(container, name, options);
    }

    @RetryOnFailure
    public void removeBlob(String container, String name) {
        this.getActiveInstance().removeBlob(container, name);
    }

    public Set<? extends Location> listAssignableLocations() {
        return this.getActiveInstance().listAssignableLocations();
    }

    public PageSet<? extends StorageMetadata> list() {
        return this.getActiveInstance().list();
    }

    public boolean containerExists(String container) {
        return this.getActiveInstance().containerExists(container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.getActiveInstance().createContainerInLocation(location, container);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        return this.getActiveInstance().createContainerInLocation(location, container, options);
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        return this.getActiveInstance().list(container);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        return this.getActiveInstance().list(container, options);
    }

    public void clearContainer(String container) {
        this.getActiveInstance().clearContainer(container);
    }

    public void clearContainer(String container, ListContainerOptions options) {
        this.getActiveInstance().clearContainer(container, options);
    }

    public void deleteContainer(String container) {
        this.getActiveInstance().deleteContainer(container);
    }

    public boolean directoryExists(String container, String directory) {
        return this.getActiveInstance().directoryExists(container, directory);
    }

    public void createDirectory(String container, String directory) {
        this.getActiveInstance().createDirectory(container, directory);
    }

    public void deleteDirectory(String containerName, String name) {
        this.getActiveInstance().deleteDirectory(containerName, name);
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        return this.getActiveInstance().putBlob(container, blob, options);
    }

    public BlobMetadata blobMetadata(String container, String name) {
        return this.getActiveInstance().blobMetadata(container, name);
    }

    public long countBlobs(String container) {
        return this.getActiveInstance().countBlobs(container);
    }

    public long countBlobs(String container, ListContainerOptions options) {
        return this.getActiveInstance().countBlobs(container, options);
    }
}

