/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import com.google.gson.Gson;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.persistent.util.QueryTracer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class CassandraRecordDAO {
    private final Gson gson = new Gson();
    @Autowired
    @Qualifier(value="dbService")
    private CassandraConnectionProvider connectionProvider;
    private PreparedStatement insertRepresentationStatement;
    private PreparedStatement deleteRepresentationVersionStatement;
    private PreparedStatement deleteRecordStatement;
    private PreparedStatement deleteRepresentationStatement;
    private PreparedStatement getRepresentationVersionStatement;
    private PreparedStatement listRepresentationVersionsStatement;
    private PreparedStatement listRepresentationVersionsAllSchemasStatement;
    private PreparedStatement persistRepresentationStatement;
    private PreparedStatement insertFileStatement;
    private PreparedStatement removeFileStatement;
    private PreparedStatement getFilesStatement;
    private PreparedStatement getAllRepresentationsForRecordStatement;
    private PreparedStatement singleRecordIdForProviderStatement;

    @PostConstruct
    private void prepareStatements() {
        Session s = this.connectionProvider.getSession();
        this.insertRepresentationStatement = s.prepare("INSERT INTO representation_versions (cloud_id, schema_id, version_id, provider_id, persistent, creation_date) VALUES (?,?,?,?,?,?);");
        this.insertRepresentationStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.getRepresentationVersionStatement = s.prepare("SELECT cloud_id, schema_id, version_id, provider_id, persistent, creation_date, files FROM representation_versions WHERE cloud_id = ? AND schema_id = ? AND version_id = ?;");
        this.getRepresentationVersionStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.listRepresentationVersionsStatement = s.prepare("SELECT cloud_id, schema_id, version_id, provider_id, persistent, creation_date, files FROM representation_versions WHERE cloud_id = ? AND schema_id = ? ORDER BY schema_id DESC, version_id DESC;");
        this.listRepresentationVersionsStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.listRepresentationVersionsAllSchemasStatement = s.prepare("SELECT cloud_id, schema_id, version_id, provider_id, persistent, creation_date, files FROM representation_versions WHERE cloud_id = ?;");
        this.listRepresentationVersionsAllSchemasStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.persistRepresentationStatement = s.prepare("UPDATE representation_versions SET persistent = TRUE, creation_date = ? WHERE cloud_id = ? AND schema_id=? AND version_id = ?;");
        this.persistRepresentationStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.insertFileStatement = s.prepare("UPDATE representation_versions SET files[?] = ? WHERE cloud_id = ? AND schema_id = ? AND version_id = ?;");
        this.insertFileStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.removeFileStatement = s.prepare("DELETE files[?] FROM representation_versions WHERE cloud_id = ? AND schema_id = ? AND version_id = ?;");
        this.removeFileStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.getFilesStatement = s.prepare("SELECT files FROM representation_versions WHERE cloud_id = ? AND schema_id = ? AND version_id = ?;");
        this.getFilesStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.getAllRepresentationsForRecordStatement = s.prepare("SELECT cloud_id, schema_id, version_id, provider_id, persistent, creation_date, files FROM representation_versions WHERE cloud_id = ? ORDER BY schema_id DESC, version_id DESC;");
        this.getAllRepresentationsForRecordStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.deleteRecordStatement = s.prepare("BEGIN BATCH DELETE FROM representation_versions WHERE cloud_id = ? DELETE FROM data_set_assignments WHERE cloud_id = ? APPLY BATCH;");
        this.deleteRecordStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.deleteRepresentationStatement = s.prepare("BEGIN BATCH DELETE FROM representation_versions WHERE cloud_id = ? AND schema_id = ? DELETE FROM data_set_assignments WHERE cloud_id = ? AND schema_id = ? APPLY BATCH;");
        this.deleteRepresentationStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.deleteRepresentationVersionStatement = s.prepare("BEGIN BATCH DELETE FROM representation_versions WHERE cloud_id = ? AND schema_id = ? AND version_id = ? DELETE FROM data_set_assignments WHERE cloud_id = ? AND schema_id = ? APPLY BATCH;");
        this.deleteRepresentationVersionStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.singleRecordIdForProviderStatement = s.prepare("SELECT cloud_id FROM representation_versions WHERE provider_id = ? LIMIT 1;");
        this.singleRecordIdForProviderStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
    }

    public Record getRecord(String cloudId) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.getAllRepresentationsForRecordStatement.bind(new Object[]{cloudId});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        ArrayList<Representation> representations = new ArrayList<Representation>();
        String prevSchema = null;
        for (Row row : rs) {
            Representation rep = this.mapToRepresentation(row);
            rep.setFiles(this.deserializeFiles(row.getMap("files", String.class, String.class)));
            if (!rep.isPersistent() || rep.getRepresentationName().equals(prevSchema)) continue;
            representations.add(rep);
            prevSchema = rep.getRepresentationName();
        }
        return new Record(cloudId, representations);
    }

    public void deleteRecord(String cloudId) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.deleteRecordStatement.bind(new Object[]{cloudId, cloudId});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public void deleteRepresentation(String cloudId, String schema) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.deleteRepresentationStatement.bind(new Object[]{cloudId, schema, cloudId, schema});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public void deleteRepresentation(String cloudId, String schema, String version) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.deleteRepresentationVersionStatement.bind(new Object[]{cloudId, schema, UUID.fromString(version), cloudId, schema});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public Representation getLatestPersistentRepresentation(String cloudId, String schema) {
        try {
            List<Representation> allRepresentations = this.listRepresentationVersions(cloudId, schema);
            for (Representation r : allRepresentations) {
                if (!r.isPersistent()) continue;
                r.setFiles(this.getFilesForRepresentation(cloudId, schema, r.getVersion()));
                return r;
            }
        }
        catch (RepresentationNotExistsException ex) {
            return null;
        }
        return null;
    }

    public Representation createRepresentation(String cloudId, String schema, String providerId, Date creationTime) throws NoHostAvailableException, QueryExecutionException {
        if (cloudId == null || schema == null || providerId == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        UUID version = CassandraRecordDAO.getTimeUUID();
        BoundStatement boundStatement = this.insertRepresentationStatement.bind(new Object[]{cloudId, schema, version, providerId, false, creationTime});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        return new Representation(cloudId, schema, version.toString(), null, null, providerId, new ArrayList(0), false, creationTime);
    }

    public Representation getRepresentation(String cloudId, String schema, String version) throws NoHostAvailableException, QueryExecutionException {
        if (cloudId == null || schema == null || version == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        BoundStatement boundStatement = this.getRepresentationVersionStatement.bind(new Object[]{cloudId, schema, UUID.fromString(version)});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        Row row = rs.one();
        if (row == null) {
            return null;
        }
        Representation rep = this.mapToRepresentation(row);
        rep.setFiles(this.deserializeFiles(row.getMap("files", String.class, String.class)));
        return rep;
    }

    public List<File> getFilesForRepresentation(String cloudId, String schema, String version) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.getFilesStatement.bind(new Object[]{cloudId, schema, UUID.fromString(version)});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        Row row = rs.one();
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        if (row == null) {
            return null;
        }
        Map fileNameToFile = row.getMap("files", String.class, String.class);
        return this.deserializeFiles(fileNameToFile);
    }

    public void persistRepresentation(String cloudId, String schema, String version, Date creationTime) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.persistRepresentationStatement.bind(new Object[]{creationTime, cloudId, schema, UUID.fromString(version)});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public List<Representation> listRepresentationVersions(String cloudId, String schema) throws NoHostAvailableException, QueryExecutionException, RepresentationNotExistsException {
        BoundStatement boundStatement = this.listRepresentationVersionsStatement.bind(new Object[]{cloudId, schema});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        ArrayList<Representation> result = new ArrayList<Representation>(rs.getAvailableWithoutFetching());
        if (rs.isExhausted()) {
            throw new RepresentationNotExistsException();
        }
        for (Row row : rs) {
            Representation representation = this.mapToRepresentation(row);
            representation.setFiles(this.deserializeFiles(row.getMap("files", String.class, String.class)));
            result.add(representation);
        }
        return result;
    }

    public List<Representation> listRepresentationVersions(String cloudId) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.listRepresentationVersionsAllSchemasStatement.bind(new Object[]{cloudId});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        ArrayList<Representation> result = new ArrayList<Representation>(rs.getAvailableWithoutFetching());
        for (Row row : rs) {
            Representation representation = this.mapToRepresentation(row);
            representation.setFiles(this.deserializeFiles(row.getMap("files", String.class, String.class)));
            result.add(representation);
        }
        return result;
    }

    public void addOrReplaceFileInRepresentation(String cloudId, String schema, String version, File file) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.insertFileStatement.bind(new Object[]{file.getFileName(), this.serializeFile(file), cloudId, schema, UUID.fromString(version)});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public void removeFileFromRepresentation(String cloudId, String schema, String version, String fileName) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.removeFileStatement.bind(new Object[]{fileName, cloudId, schema, UUID.fromString(version)});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public boolean providerHasRepresentations(String providerId) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.singleRecordIdForProviderStatement.bind(new Object[]{providerId});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        Row row = rs.one();
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        return row != null;
    }

    private Representation mapToRepresentation(Row row) {
        Representation representation = new Representation();
        representation.setDataProvider(row.getString("provider_id"));
        representation.setCloudId(row.getString("cloud_id"));
        representation.setRepresentationName(row.getString("schema_id"));
        representation.setVersion(row.getUUID("version_id").toString());
        representation.setPersistent(row.getBool("persistent"));
        representation.setCreationDate(row.getDate("creation_date"));
        return representation;
    }

    private List<File> deserializeFiles(Map<String, String> fileNameToFile) {
        if (fileNameToFile == null) {
            return new ArrayList<File>(0);
        }
        ArrayList<File> files = new ArrayList<File>(fileNameToFile.size());
        for (String fileJSON : fileNameToFile.values()) {
            files.add((File)this.gson.fromJson(fileJSON, File.class));
        }
        return files;
    }

    private String serializeFile(File f) {
        f.setContentUri(null);
        return this.gson.toJson((Object)f);
    }

    private static UUID getTimeUUID() {
        return UUID.fromString(new com.eaio.uuid.UUID().toString());
    }
}

