/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import com.google.common.base.Objects;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.CompoundDataSetId;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.persistent.util.QueryTracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class CassandraDataSetDAO {
    protected static final String CDSID_SEPARATOR = "\n";
    @Autowired
    @Qualifier(value="dbService")
    private CassandraConnectionProvider connectionProvider;
    private PreparedStatement createDataSetStatement;
    private PreparedStatement deleteDataSetStatement;
    private PreparedStatement addAssignmentStatement;
    private PreparedStatement removeAssignmentStatement;
    private PreparedStatement listDataSetAssignmentsNoPaging;
    private PreparedStatement listDataSetRepresentationsStatement;
    private PreparedStatement listDataSetsStatement;
    private PreparedStatement getDataSetStatement;
    private PreparedStatement getDataSetsForRepresentationStatement;

    @PostConstruct
    private void prepareStatements() {
        this.createDataSetStatement = this.connectionProvider.getSession().prepare("INSERT INTO data_sets(provider_id, dataset_id, description, creation_date) VALUES (?,?,?,?);");
        this.createDataSetStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.deleteDataSetStatement = this.connectionProvider.getSession().prepare("DELETE FROM data_sets WHERE provider_id = ? AND dataset_id = ?;");
        this.deleteDataSetStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.addAssignmentStatement = this.connectionProvider.getSession().prepare("INSERT INTO data_set_assignments (provider_dataset_id, cloud_id, schema_id, version_id, creation_date) VALUES (?,?,?,?,?);");
        this.addAssignmentStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.removeAssignmentStatement = this.connectionProvider.getSession().prepare("DELETE FROM data_set_assignments WHERE provider_dataset_id = ? AND cloud_id = ? AND schema_id = ?;");
        this.removeAssignmentStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.listDataSetAssignmentsNoPaging = this.connectionProvider.getSession().prepare("SELECT cloud_id, schema_id FROM data_set_assignments WHERE provider_dataset_id = ?;");
        this.listDataSetAssignmentsNoPaging.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.listDataSetRepresentationsStatement = this.connectionProvider.getSession().prepare("SELECT cloud_id, schema_id, version_id  FROM data_set_assignments WHERE provider_dataset_id = ? AND token(cloud_id) >= token(?) AND schema_id >= ? LIMIT ? ALLOW FILTERING;");
        this.listDataSetRepresentationsStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.listDataSetsStatement = this.connectionProvider.getSession().prepare("SELECT provider_id, dataset_id, description FROM data_sets WHERE provider_id = ? AND dataset_id >= ? LIMIT ?;");
        this.listDataSetsStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.getDataSetStatement = this.connectionProvider.getSession().prepare("SELECT provider_id, dataset_id, description FROM data_sets WHERE provider_id = ? AND dataset_id = ?;");
        this.getDataSetStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
        this.getDataSetsForRepresentationStatement = this.connectionProvider.getSession().prepare("SELECT provider_dataset_id, version_id FROM data_set_assignments WHERE cloud_id = ? AND schema_id = ?;");
        this.getDataSetsForRepresentationStatement.setConsistencyLevel(this.connectionProvider.getConsistencyLevel());
    }

    public List<Representation> listDataSet(String providerId, String dataSetId, String thresholdCloudId, String thresholdSchema, int limit) throws NoHostAvailableException, QueryExecutionException {
        String providerDataSetId = this.createProviderDataSetId(providerId, dataSetId);
        BoundStatement boundStatement = this.listDataSetRepresentationsStatement.bind(new Object[]{providerDataSetId, thresholdCloudId != null ? thresholdCloudId : "", thresholdSchema != null ? thresholdSchema : "", limit});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        ArrayList<Representation> representationStubs = new ArrayList<Representation>(limit);
        for (Row row : rs) {
            Representation stub = this.mapRowToRepresentationStub(row);
            representationStubs.add(stub);
        }
        return representationStubs;
    }

    public void addAssignment(String providerId, String dataSetId, String recordId, String schema, String version) throws NoHostAvailableException, QueryExecutionException {
        Date now = new Date();
        String providerDataSetId = this.createProviderDataSetId(providerId, dataSetId);
        UUID versionId = null;
        if (version != null) {
            versionId = UUID.fromString(version);
        }
        BoundStatement boundStatement = this.addAssignmentStatement.bind(new Object[]{providerDataSetId, recordId, schema, versionId, now});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public Collection<CompoundDataSetId> getDataSetAssignments(String cloudId, String schemaId, String version) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.getDataSetsForRepresentationStatement.bind(new Object[]{cloudId, schemaId});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        ArrayList<CompoundDataSetId> ids = new ArrayList<CompoundDataSetId>();
        for (Row r : rs) {
            UUID versionId = r.getUUID("version_id");
            String versionIdString = versionId == null ? null : versionId.toString();
            if (!Objects.equal((Object)version, (Object)versionIdString)) continue;
            String providerDataSetId = r.getString("provider_dataset_id");
            ids.add(this.createCompoundDataSetId(providerDataSetId));
        }
        return ids;
    }

    public DataSet getDataSet(String providerId, String dataSetId) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.getDataSetStatement.bind(new Object[]{providerId, dataSetId});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        Row row = rs.one();
        if (row == null) {
            return null;
        }
        DataSet ds = new DataSet();
        ds.setProviderId(providerId);
        ds.setId(dataSetId);
        ds.setDescription(row.getString("description"));
        return ds;
    }

    public void removeAssignment(String providerId, String dataSetId, String recordId, String schema) throws NoHostAvailableException, QueryExecutionException {
        String providerDataSetId = this.createProviderDataSetId(providerId, dataSetId);
        BoundStatement boundStatement = this.removeAssignmentStatement.bind(new Object[]{providerDataSetId, recordId, schema});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
    }

    public DataSet createDataSet(String providerId, String dataSetId, String description, Date creationTime) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.createDataSetStatement.bind(new Object[]{providerId, dataSetId, description, creationTime});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        DataSet ds = new DataSet();
        ds.setId(dataSetId);
        ds.setDescription(description);
        ds.setProviderId(providerId);
        return ds;
    }

    public List<DataSet> getDataSets(String providerId, String thresholdDatasetId, int limit) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.listDataSetsStatement.bind(new Object[]{providerId, thresholdDatasetId != null ? thresholdDatasetId : "", limit});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        ArrayList<DataSet> result = new ArrayList<DataSet>(limit);
        for (Row row : rs) {
            DataSet ds = new DataSet();
            ds.setProviderId(providerId);
            ds.setId(row.getString("dataset_id"));
            ds.setDescription(row.getString("description"));
            result.add(ds);
        }
        return result;
    }

    public void deleteDataSet(String providerId, String dataSetId) throws NoHostAvailableException, QueryExecutionException {
        String providerDataSetId = this.createProviderDataSetId(providerId, dataSetId);
        BoundStatement boundStatement = this.listDataSetAssignmentsNoPaging.bind(new Object[]{providerDataSetId});
        ResultSet rs = this.connectionProvider.getSession().execute((Statement)boundStatement);
        QueryTracer.logConsistencyLevel(boundStatement, rs);
        for (Row row : rs) {
            String cloudId = row.getString("cloud_id");
            String schemaId = row.getString("schema_id");
            this.connectionProvider.getSession().execute((Statement)this.removeAssignmentStatement.bind(new Object[]{providerDataSetId, cloudId, schemaId}));
        }
        boundStatement = this.deleteDataSetStatement.bind(new Object[]{providerId, dataSetId});
        this.connectionProvider.getSession().execute((Statement)boundStatement);
    }

    private String createProviderDataSetId(String providerId, String dataSetId) {
        return providerId + CDSID_SEPARATOR + dataSetId;
    }

    private CompoundDataSetId createCompoundDataSetId(String providerDataSetId) {
        String[] values = providerDataSetId.split(CDSID_SEPARATOR);
        if (values.length != 2) {
            throw new IllegalArgumentException("Cannot construct proper compound data set id from value: " + providerDataSetId);
        }
        return new CompoundDataSetId(values[0], values[1]);
    }

    private Representation mapRowToRepresentationStub(Row row) {
        Representation representation = new Representation();
        representation.setCloudId(row.getString("cloud_id"));
        representation.setRepresentationName(row.getString("schema_id"));
        UUID verisonId = row.getUUID("version_id");
        if (verisonId != null) {
            representation.setVersion(verisonId.toString());
        }
        return representation;
    }
}

