/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.aspects;

import eu.europeana.cloud.service.mcs.persistent.exception.SystemException;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class ServiceExceptionTranslator {
    @Pointcut(value="@within(org.springframework.stereotype.Service)")
    private void isService() {
    }

    @Pointcut(value="within(eu.europeana.cloud.service.mcs.persistent..*)")
    private void inMCSPersistentPackage() {
    }

    @AfterThrowing(pointcut="isService() && inMCSPersistentPackage()", throwing="ex")
    public void wrapException(RuntimeException ex) {
        if (ex instanceof SystemException) {
            return;
        }
        SystemException wrappedException = new SystemException(ex.getMessage(), ex);
        wrappedException.setStackTrace(ex.getStackTrace());
        throw wrappedException;
    }
}

