/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent.aspects;

import eu.europeana.cloud.service.mcs.persistent.exception.SwiftConnectionException;
import eu.europeana.cloud.service.mcs.persistent.swift.SwiftConnectionProvider;
import eu.europeana.cloud.service.mcs.persistent.swift.SwiftContentDAO;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jclouds.rest.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class RetryOnTokenExpiryExecutor {
    @Autowired
    SwiftConnectionProvider provider;
    private int numberOfRetries;
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryOnTokenExpiryExecutor.class);

    @PostConstruct
    public void init() {
        this.numberOfRetries = 1;
    }

    @Pointcut(value="execution(* eu.europeana.cloud.service.mcs.persistent.swift.SwiftContentDAO.*(..))")
    private void isSwiftContentDAOFunction() {
    }

    @Around(value="isSwiftContentDAOFunction()")
    public Object retry(ProceedingJoinPoint pjp) throws Throwable {
        try {
            return pjp.proceed();
        }
        catch (SwiftConnectionException | AuthorizationException e) {
            LOGGER.info("Failrue connect to the proxy. Try: 1. Cause" + e.getMessage());
            return this.retryOnFailure((SwiftContentDAO)pjp.getTarget(), pjp.getSignature(), pjp.getArgs());
        }
    }

    private Object retryOnFailure(SwiftContentDAO contentDAO, Signature signature, Object[] args) throws NoSuchMethodException, IllegalAccessException, Throwable {
        for (int i = 0; i < this.numberOfRetries; ++i) {
            this.provider.reconnectConnections();
            try {
                Method method = ((MethodSignature)signature).getMethod();
                Object o = method.invoke((Object)contentDAO, args);
                return o;
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof SwiftConnectionException) && !(e.getTargetException() instanceof AuthorizationException)) {
                    throw e.getTargetException();
                }
                LOGGER.info("Failrue connect to the proxy. Try: " + (i + 2) + " Cause:" + e.getTargetException().getMessage());
                continue;
            }
        }
        throw new RuntimeException("All instances of Swift are down");
    }
}

