/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.europeana.cloud.common.model.CompoundDataSetId;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.kafka.ProducerWrapper;
import eu.europeana.cloud.service.mcs.messages.AddAssignmentMessage;
import eu.europeana.cloud.service.mcs.messages.InsertRepresentationMessage;
import eu.europeana.cloud.service.mcs.messages.InsertRepresentationPersistentMessage;
import eu.europeana.cloud.service.mcs.messages.RemoveAssignmentMessage;
import eu.europeana.cloud.service.mcs.messages.RemoveAssignmentsFromDataSetMessage;
import eu.europeana.cloud.service.mcs.messages.RemoveRecordRepresentationsMessage;
import eu.europeana.cloud.service.mcs.messages.RemoveRepresentationMessage;
import eu.europeana.cloud.service.mcs.messages.RemoveRepresentationVersionMessage;
import eu.europeana.cloud.service.mcs.persistent.cassandra.CassandraDataSetDAO;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SolrRepresentationIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrRepresentationIndexer.class);
    @Autowired
    private CassandraDataSetDAO cassandraDataSetDAO;
    @Autowired(required=true)
    private ProducerWrapper producerWrapper;
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").create();

    public void insertRepresentation(Representation representation, int partitionKey) {
        if (!representation.isPersistent()) {
            this.producerWrapper.send(partitionKey, this.serialize((Serializable)new InsertRepresentationMessage(this.prepareInsertRepresentationMessage(representation))));
        } else {
            Collection<CompoundDataSetId> dataSetIds = this.cassandraDataSetDAO.getDataSetAssignments(representation.getCloudId(), representation.getRepresentationName(), null);
            this.producerWrapper.send(partitionKey, this.serialize((Serializable)new InsertRepresentationPersistentMessage(this.prepareInsertPersistentRepresentationMessage(representation, dataSetIds))));
        }
    }

    private String prepareInsertRepresentationMessage(Representation representation) {
        return this.gson.toJson((Object)representation);
    }

    private String prepareInsertPersistentRepresentationMessage(Representation representation, Collection<CompoundDataSetId> dataSetIds) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("representation", representation);
        map.put("dataSets", dataSetIds);
        return this.gson.toJson(map);
    }

    public void removeRepresentationVersion(String versionId, int partitionKey) {
        this.producerWrapper.send(partitionKey, this.serialize((Serializable)new RemoveRepresentationVersionMessage(versionId)));
    }

    public void removeRepresentation(String cloudId, String representationName, int partitionKey) {
        this.producerWrapper.send(partitionKey, this.serialize((Serializable)new RemoveRepresentationMessage(this.prepareRemoveRepresentationMsg(cloudId, representationName))));
    }

    private String prepareRemoveRepresentationMsg(String cloudId, String representationName) {
        JsonObject jo = new JsonObject();
        jo.addProperty("CLOUDID", cloudId);
        jo.addProperty("REPRESENTATIONNAME", representationName);
        return jo.toString();
    }

    public void removeRecordRepresentations(String cloudId, int partitionKey) {
        this.producerWrapper.send(partitionKey, this.serialize((Serializable)new RemoveRecordRepresentationsMessage(cloudId)));
    }

    public void removeAssignment(String cloudId, String representationName, CompoundDataSetId dataSetId, int partitionKey) {
        this.producerWrapper.send(partitionKey, this.serialize((Serializable)new RemoveAssignmentMessage(this.prepareRemoveAssignmentMessage(cloudId, representationName, dataSetId))));
    }

    private String prepareRemoveAssignmentMessage(String cloudId, String representationName, CompoundDataSetId dataSetId) {
        JsonObject jo = this.prepareCompoundDataSetIdJson(dataSetId);
        jo.addProperty("CLOUDID", cloudId);
        jo.addProperty("REPRESENTATIONNAME", representationName);
        return jo.toString();
    }

    public void addAssignment(String versionId, CompoundDataSetId dataSetId, int partitionKey) {
        this.producerWrapper.send(partitionKey, this.serialize((Serializable)new AddAssignmentMessage(this.prepareAddAssignmentMsg(versionId, dataSetId))));
    }

    private String prepareAddAssignmentMsg(String versionId, CompoundDataSetId dataSetId) {
        JsonObject jo = this.prepareCompoundDataSetIdJson(dataSetId);
        jo.addProperty("VERSION", versionId);
        return jo.toString();
    }

    public void removeAssignmentsFromDataSet(CompoundDataSetId compoundDataSetId, int partitionKey) {
        this.producerWrapper.send(partitionKey, this.serialize((Serializable)new RemoveAssignmentsFromDataSetMessage(this.gson.toJson((Object)compoundDataSetId))));
    }

    private JsonObject prepareCompoundDataSetIdJson(CompoundDataSetId dataSetId) {
        JsonElement elem = this.gson.toJsonTree((Object)dataSetId, CompoundDataSetId.class);
        JsonObject jo = new JsonObject();
        jo.add("dataSetProviderId", elem);
        return jo;
    }

    private byte[] serialize(Serializable in) {
        return SerializationUtils.serialize((Serializable)in);
    }
}

