/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent;

import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.utils.FileUtils;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.UISClientHandler;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.CannotPersistEmptyRepresentationException;
import eu.europeana.cloud.service.mcs.exception.FileAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import eu.europeana.cloud.service.mcs.persistent.SolrRepresentationIndexer;
import eu.europeana.cloud.service.mcs.persistent.cassandra.CassandraRecordDAO;
import eu.europeana.cloud.service.mcs.persistent.exception.SystemException;
import eu.europeana.cloud.service.mcs.persistent.swift.PutResult;
import eu.europeana.cloud.service.mcs.persistent.swift.SwiftContentDAO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CassandraRecordService
implements RecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraRecordService.class);
    @Autowired
    private CassandraRecordDAO recordDAO;
    @Autowired
    private SwiftContentDAO contentDAO;
    @Autowired
    private SolrRepresentationIndexer representationIndexer;
    @Autowired
    private UISClientHandler uis;

    public Record getRecord(String cloudId) throws RecordNotExistsException {
        Record record = null;
        if (this.uis.existsCloudId(cloudId)) {
            record = this.recordDAO.getRecord(cloudId);
            if (record.getRepresentations().isEmpty()) {
                throw new RecordNotExistsException(cloudId);
            }
        } else {
            throw new RecordNotExistsException(cloudId);
        }
        return record;
    }

    public void deleteRecord(String cloudId) throws RecordNotExistsException, RepresentationNotExistsException {
        if (this.uis.existsCloudId(cloudId)) {
            List<Representation> allRecordRepresentationsInAllVersions = this.recordDAO.listRepresentationVersions(cloudId);
            if (allRecordRepresentationsInAllVersions.isEmpty()) {
                throw new RepresentationNotExistsException(String.format("No representation found for given cloudId %s", cloudId));
            }
            CassandraRecordService.sortByProviderId(allRecordRepresentationsInAllVersions);
            String dPId = null;
            for (Representation repVersion : allRecordRepresentationsInAllVersions) {
                if (!repVersion.getDataProvider().equalsIgnoreCase(dPId)) {
                    dPId = repVersion.getDataProvider();
                    this.representationIndexer.removeRecordRepresentations(cloudId, this.uis.getProvider(dPId).getPartitionKey());
                }
                for (File f : repVersion.getFiles()) {
                    try {
                        this.contentDAO.deleteContent(FileUtils.generateKeyForFile((String)cloudId, (String)repVersion.getRepresentationName(), (String)repVersion.getVersion(), (String)f.getFileName()));
                    }
                    catch (FileNotExistsException ex) {
                        LOGGER.warn("File {} was found in representation {}-{}-{} but no content of such file was found", new Object[]{f.getFileName(), cloudId, repVersion.getRepresentationName(), repVersion.getVersion()});
                    }
                }
            }
        } else {
            throw new RecordNotExistsException(cloudId);
        }
        this.recordDAO.deleteRecord(cloudId);
    }

    public void deleteRepresentation(String globalId, String schema) throws RepresentationNotExistsException {
        List<Representation> listRepresentations = this.recordDAO.listRepresentationVersions(globalId, schema);
        CassandraRecordService.sortByProviderId(listRepresentations);
        String dPId = null;
        for (Representation rep : listRepresentations) {
            if (!rep.getDataProvider().equalsIgnoreCase(dPId)) {
                dPId = rep.getDataProvider();
                this.representationIndexer.removeRepresentation(globalId, schema, this.uis.getProvider(dPId).getPartitionKey());
            }
            for (File f : rep.getFiles()) {
                try {
                    this.contentDAO.deleteContent(FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)rep.getVersion(), (String)f.getFileName()));
                }
                catch (FileNotExistsException ex) {
                    LOGGER.warn("File {} was found in representation {}-{}-{} but no content of such file was found", new Object[]{f.getFileName(), globalId, rep.getRepresentationName(), rep.getVersion()});
                }
            }
        }
        this.recordDAO.deleteRepresentation(globalId, schema);
    }

    public Representation createRepresentation(String cloudId, String representationName, String providerId) throws ProviderNotExistsException, RecordNotExistsException {
        Date now = new Date();
        DataProvider dataProvider = this.uis.getProvider(providerId);
        if (dataProvider == null) {
            throw new ProviderNotExistsException(String.format("Provider %s does not exist.", providerId));
        }
        if (this.uis.existsCloudId(cloudId)) {
            Representation rep = this.recordDAO.createRepresentation(cloudId, representationName, providerId, now);
            this.representationIndexer.insertRepresentation(rep, dataProvider.getPartitionKey());
            return rep;
        }
        throw new RecordNotExistsException(cloudId);
    }

    public Representation getRepresentation(String globalId, String schema) throws RepresentationNotExistsException {
        Representation rep = this.recordDAO.getLatestPersistentRepresentation(globalId, schema);
        if (rep == null) {
            throw new RepresentationNotExistsException();
        }
        return rep;
    }

    public Representation getRepresentation(String globalId, String schema, String version) throws RepresentationNotExistsException {
        Representation rep = this.recordDAO.getRepresentation(globalId, schema, version);
        if (rep == null) {
            throw new RepresentationNotExistsException();
        }
        return rep;
    }

    public void deleteRepresentation(String globalId, String schema, String version) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException {
        Representation rep = this.recordDAO.getRepresentation(globalId, schema, version);
        if (rep == null) {
            throw new RepresentationNotExistsException();
        }
        if (rep.isPersistent()) {
            throw new CannotModifyPersistentRepresentationException();
        }
        this.representationIndexer.removeRepresentationVersion(version, this.uis.getProvider(rep.getDataProvider()).getPartitionKey());
        for (File f : rep.getFiles()) {
            try {
                this.contentDAO.deleteContent(FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)version, (String)f.getFileName()));
            }
            catch (FileNotExistsException ex) {
                LOGGER.warn("File {} was found in representation {}-{}-{} but no content of such file was found", new Object[]{f.getFileName(), globalId, rep.getRepresentationName(), rep.getVersion()});
            }
        }
        this.recordDAO.deleteRepresentation(globalId, schema, version);
    }

    public Representation persistRepresentation(String globalId, String schema, String version) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, CannotPersistEmptyRepresentationException {
        Date now = new Date();
        Representation rep = this.recordDAO.getRepresentation(globalId, schema, version);
        if (rep == null) {
            throw new RepresentationNotExistsException();
        }
        if (rep.isPersistent()) {
            throw new CannotModifyPersistentRepresentationException();
        }
        List<File> recordFiles = this.recordDAO.getFilesForRepresentation(globalId, schema, version);
        if (recordFiles == null) {
            throw new RepresentationNotExistsException();
        }
        if (recordFiles.isEmpty()) {
            throw new CannotPersistEmptyRepresentationException();
        }
        this.recordDAO.persistRepresentation(globalId, schema, version, now);
        rep.setPersistent(true);
        rep.setCreationDate(now);
        this.representationIndexer.insertRepresentation(rep, this.uis.getProvider(rep.getDataProvider()).getPartitionKey());
        return rep;
    }

    public List<Representation> listRepresentationVersions(String globalId, String schema) throws RepresentationNotExistsException {
        return this.recordDAO.listRepresentationVersions(globalId, schema);
    }

    public boolean putContent(String globalId, String schema, String version, File file, InputStream content) throws CannotModifyPersistentRepresentationException, RepresentationNotExistsException {
        PutResult result;
        DateTime now = new DateTime();
        Representation representation = this.getRepresentation(globalId, schema, version);
        if (representation.isPersistent()) {
            throw new CannotModifyPersistentRepresentationException();
        }
        boolean isCreate = true;
        for (File f : representation.getFiles()) {
            if (!f.getFileName().equals(file.getFileName())) continue;
            isCreate = false;
            break;
        }
        String keyForFile = FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)version, (String)file.getFileName());
        try {
            result = this.contentDAO.putContent(keyForFile, content);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
        file.setMd5(result.getMd5());
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        file.setDate(fmt.print((ReadableInstant)now));
        file.setContentLength(result.getContentLength().longValue());
        this.recordDAO.addOrReplaceFileInRepresentation(globalId, schema, version, file);
        return isCreate;
    }

    public void getContent(String globalId, String schema, String version, String fileName, long rangeStart, long rangeEnd, OutputStream os) throws FileNotExistsException, WrongContentRangeException, RepresentationNotExistsException {
        File file = this.getFile(globalId, schema, version, fileName);
        if (rangeStart > file.getContentLength() - 1L) {
            throw new WrongContentRangeException("Start range must be less than file length");
        }
        try {
            this.contentDAO.getContent(FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)version, (String)fileName), rangeStart, rangeEnd, os);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public String getContent(String globalId, String schema, String version, String fileName, OutputStream os) throws FileNotExistsException, RepresentationNotExistsException {
        Representation rep = this.getRepresentation(globalId, schema, version);
        String md5 = null;
        for (File f : rep.getFiles()) {
            if (!fileName.equals(f.getFileName())) continue;
            md5 = f.getMd5();
        }
        if (md5 == null) {
            throw new FileNotExistsException();
        }
        try {
            this.contentDAO.getContent(FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)version, (String)fileName), -1L, -1L, os);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
        return md5;
    }

    public void deleteContent(String globalId, String schema, String version, String fileName) throws FileNotExistsException, CannotModifyPersistentRepresentationException, RepresentationNotExistsException {
        Representation representation = this.getRepresentation(globalId, schema, version);
        if (representation.isPersistent()) {
            throw new CannotModifyPersistentRepresentationException();
        }
        this.recordDAO.removeFileFromRepresentation(globalId, schema, version, fileName);
        this.contentDAO.deleteContent(FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)version, (String)fileName));
    }

    public Representation copyRepresentation(String globalId, String schema, String version) throws RepresentationNotExistsException {
        Date now = new Date();
        Representation srcRep = this.recordDAO.getRepresentation(globalId, schema, version);
        if (srcRep == null) {
            throw new RepresentationNotExistsException();
        }
        Representation copiedRep = this.recordDAO.createRepresentation(globalId, schema, srcRep.getDataProvider(), now);
        this.representationIndexer.insertRepresentation(copiedRep, this.uis.getProvider(srcRep.getDataProvider()).getPartitionKey());
        for (File srcFile : srcRep.getFiles()) {
            File copiedFile = new File(srcFile);
            try {
                this.contentDAO.copyContent(FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)version, (String)srcFile.getFileName()), FileUtils.generateKeyForFile((String)globalId, (String)schema, (String)copiedRep.getVersion(), (String)copiedFile.getFileName()));
            }
            catch (FileNotExistsException ex) {
                LOGGER.warn("File {} was found in representation {}-{}-{} but no content of such file was found", new Object[]{srcFile.getFileName(), globalId, schema, version});
            }
            catch (FileAlreadyExistsException ex) {
                LOGGER.warn("File already exists in newly created representation?", new Object[]{copiedFile.getFileName(), globalId, schema, copiedRep.getVersion()});
            }
            this.recordDAO.addOrReplaceFileInRepresentation(globalId, schema, copiedRep.getVersion(), copiedFile);
        }
        return this.recordDAO.getRepresentation(globalId, schema, copiedRep.getVersion());
    }

    public File getFile(String globalId, String schema, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException {
        Representation rep = this.getRepresentation(globalId, schema, version);
        for (File f : rep.getFiles()) {
            if (!f.getFileName().equals(fileName)) continue;
            return f;
        }
        throw new FileNotExistsException();
    }

    private static void sortByProviderId(List<Representation> input) {
        Collections.sort(input, new Comparator<Representation>(){

            @Override
            public int compare(Representation r1, Representation r2) {
                return r1.getDataProvider().compareToIgnoreCase(r2.getDataProvider());
            }
        });
    }
}

