/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.persistent;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import eu.europeana.cloud.common.model.CompoundDataSetId;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.UISClientHandler;
import eu.europeana.cloud.service.mcs.exception.DataSetAlreadyExistsException;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.persistent.SolrRepresentationIndexer;
import eu.europeana.cloud.service.mcs.persistent.cassandra.CassandraDataSetDAO;
import eu.europeana.cloud.service.mcs.persistent.cassandra.CassandraRecordDAO;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CassandraDataSetService
implements DataSetService {
    @Autowired
    private CassandraDataSetDAO dataSetDAO;
    @Autowired
    private CassandraRecordDAO recordDAO;
    @Autowired
    private SolrRepresentationIndexer representationIndexer;
    @Autowired
    private UISClientHandler uis;

    public ResultSlice<Representation> listDataSet(String providerId, String dataSetId, String thresholdParam, int limit) throws DataSetNotExistsException {
        DataSet ds = this.dataSetDAO.getDataSet(providerId, dataSetId);
        if (ds == null) {
            throw new DataSetNotExistsException();
        }
        String thresholdCloudId = null;
        String thresholdSchemaId = null;
        if (thresholdParam != null) {
            List<String> thresholdCloudIdAndSchema = this.decodeParams(thresholdParam);
            if (thresholdCloudIdAndSchema.size() != 2) {
                throw new IllegalArgumentException("Wrong threshold param!");
            }
            thresholdCloudId = thresholdCloudIdAndSchema.get(0);
            thresholdSchemaId = thresholdCloudIdAndSchema.get(1);
        }
        List<Representation> representationStubs = this.dataSetDAO.listDataSet(providerId, dataSetId, thresholdCloudId, thresholdSchemaId, limit + 1);
        String nextResultToken = null;
        if (representationStubs.size() == limit + 1) {
            Representation nextResult = representationStubs.get(limit);
            nextResultToken = this.encodeParams(nextResult.getCloudId(), nextResult.getRepresentationName());
            representationStubs.remove(limit);
        }
        ArrayList<Representation> representations = new ArrayList<Representation>(representationStubs.size());
        for (Representation stub : representationStubs) {
            if (stub.getVersion() == null) {
                representations.add(this.recordDAO.getLatestPersistentRepresentation(stub.getCloudId(), stub.getRepresentationName()));
                continue;
            }
            representations.add(this.recordDAO.getRepresentation(stub.getCloudId(), stub.getRepresentationName(), stub.getVersion()));
        }
        return new ResultSlice(nextResultToken, representations);
    }

    public void addAssignment(String providerId, String dataSetId, String recordId, String schema, String version) throws DataSetNotExistsException, RepresentationNotExistsException {
        Representation rep;
        DataSet ds = this.dataSetDAO.getDataSet(providerId, dataSetId);
        if (ds == null) {
            throw new DataSetNotExistsException();
        }
        if (version == null ? (rep = this.recordDAO.getLatestPersistentRepresentation(recordId, schema)) == null : (rep = this.recordDAO.getRepresentation(recordId, schema, version)) == null) {
            throw new RepresentationNotExistsException();
        }
        this.dataSetDAO.addAssignment(providerId, dataSetId, recordId, schema, version);
        DataProvider dataProvider = this.uis.getProvider(providerId);
        this.representationIndexer.addAssignment(rep.getVersion(), new CompoundDataSetId(providerId, dataSetId), dataProvider.getPartitionKey());
    }

    public void removeAssignment(String providerId, String dataSetId, String recordId, String schema) throws DataSetNotExistsException {
        DataSet ds = this.dataSetDAO.getDataSet(providerId, dataSetId);
        if (ds == null) {
            throw new DataSetNotExistsException();
        }
        this.dataSetDAO.removeAssignment(providerId, dataSetId, recordId, schema);
        DataProvider dataProvider = this.uis.getProvider(providerId);
        this.representationIndexer.removeAssignment(recordId, schema, new CompoundDataSetId(providerId, dataSetId), dataProvider.getPartitionKey());
    }

    public DataSet createDataSet(String providerId, String dataSetId, String description) throws ProviderNotExistsException, DataSetAlreadyExistsException {
        Date now = new Date();
        if (this.uis.getProvider(providerId) == null) {
            throw new ProviderNotExistsException();
        }
        DataSet ds = this.dataSetDAO.getDataSet(providerId, dataSetId);
        if (ds != null) {
            throw new DataSetAlreadyExistsException();
        }
        return this.dataSetDAO.createDataSet(providerId, dataSetId, description, now);
    }

    public DataSet updateDataSet(String providerId, String dataSetId, String description) throws DataSetNotExistsException {
        Date now = new Date();
        DataSet ds = this.dataSetDAO.getDataSet(providerId, dataSetId);
        if (ds == null) {
            throw new DataSetNotExistsException("Provider " + providerId + " does not have data set with id " + dataSetId);
        }
        return this.dataSetDAO.createDataSet(providerId, dataSetId, description, now);
    }

    public ResultSlice<DataSet> getDataSets(String providerId, String thresholdDatasetId, int limit) {
        List<DataSet> dataSets = this.dataSetDAO.getDataSets(providerId, thresholdDatasetId, limit + 1);
        String nextDataSet = null;
        if (dataSets.size() == limit + 1) {
            DataSet nextResult = dataSets.get(limit);
            nextDataSet = nextResult.getId();
            dataSets.remove(limit);
        }
        return new ResultSlice(nextDataSet, dataSets);
    }

    public void deleteDataSet(String providerId, String dataSetId) throws DataSetNotExistsException {
        DataSet ds = this.dataSetDAO.getDataSet(providerId, dataSetId);
        if (ds == null) {
            throw new DataSetNotExistsException();
        }
        this.dataSetDAO.deleteDataSet(providerId, dataSetId);
        DataProvider dataProvider = this.uis.getProvider(providerId);
        this.representationIndexer.removeAssignmentsFromDataSet(new CompoundDataSetId(providerId, dataSetId), dataProvider.getPartitionKey());
    }

    private String encodeParams(String ... parts) {
        byte[] paramsJoined = Joiner.on((char)'\n').join((Object[])parts).getBytes(Charset.forName("UTF-8"));
        return BaseEncoding.base32().encode(paramsJoined);
    }

    private List<String> decodeParams(String encodedParams) {
        byte[] paramsDecoded = BaseEncoding.base32().decode((CharSequence)encodedParams);
        String paramsDecodedString = new String(paramsDecoded, Charset.forName("UTF-8"));
        return Splitter.on((char)'\n').splitToList((CharSequence)paramsDecodedString);
    }
}

