/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.kafka;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProducerWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerWrapper.class);
    private final Producer<String, byte[]> kafkaProducer;
    private final String topic;

    public ProducerWrapper(String brokerList, String topic) {
        this.topic = topic;
        Properties properties = new Properties();
        properties.put("metadata.broker.list", brokerList);
        properties.put("serializer.class", "kafka.serializer.DefaultEncoder");
        properties.put("key.serializer.class", "kafka.serializer.StringEncoder");
        properties.put("partitioner.class", "eu.europeana.cloud.service.mcs.kafka.CustomPartitioner");
        properties.put("producer.type", "sync");
        properties.put("request.required.acks", "-1");
        this.kafkaProducer = new Producer(new ProducerConfig(properties));
    }

    public void send(int partitionRoutingKey, byte[] payload) {
        KeyedMessage message = new KeyedMessage(this.topic, (Object)Integer.toString(partitionRoutingKey), (Object)payload);
        this.kafkaProducer.send(message);
    }
}

