/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.service.utils.indexing;

import eu.europeana.cloud.service.dps.service.utils.indexing.IndexWrapper;
import eu.europeana.cloud.service.dps.service.utils.indexing.IndexingPropertiesTransformer;
import eu.europeana.cloud.service.web.common.properties.IndexingProperties;
import eu.europeana.indexing.IndexingSettings;
import eu.europeana.indexing.exception.IndexingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingSettingsGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingSettingsGenerator.class);
    protected final IndexingProperties previewIndexingProperties;
    protected final IndexingProperties publishIndexingProperties;

    public IndexingSettingsGenerator(IndexingProperties previewIndexingProperties, IndexingProperties publishIndexingProperties) {
        this.previewIndexingProperties = previewIndexingProperties;
        this.publishIndexingProperties = publishIndexingProperties;
    }

    public IndexingSettingsGenerator(Properties indexingPropertyFile) {
        this.previewIndexingProperties = IndexingPropertiesTransformer.getIndexingPropertiesFromPropertyFile(indexingPropertyFile, IndexWrapper.IndexingType.PREVIEW);
        this.publishIndexingProperties = IndexingPropertiesTransformer.getIndexingPropertiesFromPropertyFile(indexingPropertyFile, IndexWrapper.IndexingType.PUBLISH);
    }

    public IndexingSettings generateForPreview() throws IndexingException, URISyntaxException {
        if (this.isNotDefinedFor(this.previewIndexingProperties)) {
            return null;
        }
        IndexingSettings indexingSettings = new IndexingSettings();
        this.prepareSettingFor(this.previewIndexingProperties, indexingSettings);
        return indexingSettings;
    }

    public IndexingSettings generateForPublish() throws IndexingException, URISyntaxException {
        if (this.isNotDefinedFor(this.publishIndexingProperties)) {
            return null;
        }
        IndexingSettings indexingSettings = new IndexingSettings();
        this.prepareSettingFor(this.publishIndexingProperties, indexingSettings);
        return indexingSettings;
    }

    private boolean isNotDefinedFor(IndexingProperties indexingProperties) {
        return indexingProperties.getMongoInstances() == null;
    }

    private void prepareSettingFor(IndexingProperties indexingProperties, IndexingSettings indexingSettings) throws IndexingException, URISyntaxException {
        this.prepareMongoSettings(indexingSettings, indexingProperties);
        this.prepareSolrSetting(indexingSettings, indexingProperties);
        this.prepareZookeeperSettings(indexingSettings, indexingProperties);
    }

    private void prepareMongoSettings(IndexingSettings indexingSettings, IndexingProperties indexingProperties) throws IndexingException {
        String[] instances;
        String mongoInstances = indexingProperties.getMongoInstances();
        int mongoPort = indexingProperties.getMongoPortNumber();
        for (String instance : instances = mongoInstances.trim().split(",")) {
            indexingSettings.addMongoHost(new InetSocketAddress(instance, mongoPort));
        }
        indexingSettings.setMongoDatabaseName(indexingProperties.getMongoDbName());
        indexingSettings.setRecordRedirectDatabaseName(indexingProperties.getMongoRedirectsDbName());
        if (this.mongoCredentialsProvidedFor(indexingProperties)) {
            indexingSettings.setMongoCredentials(indexingProperties.getMongoUsername(), indexingProperties.getMongoPassword(), indexingProperties.getMongoAuthDb());
        } else {
            LOGGER.info("Mongo credentials not provided");
        }
        Optional<Integer> optionalMongoPoolSize = Optional.ofNullable(indexingProperties.getMongoPoolSize());
        optionalMongoPoolSize.ifPresentOrElse(arg_0 -> ((IndexingSettings)indexingSettings).setMongoMaxConnectionPoolSize(arg_0), () -> LOGGER.warn("Mongo max connection pool size not provided"));
        if (indexingProperties.getMongoUseSSL() != null && indexingProperties.getMongoUseSSL().equalsIgnoreCase("true")) {
            indexingSettings.setMongoEnableSsl();
        }
        indexingSettings.setMongoReadPreference(indexingProperties.getMongoReadPreference());
        indexingSettings.setMongoApplicationName(indexingProperties.getMongoApplicationName());
    }

    private boolean mongoCredentialsProvidedFor(IndexingProperties indexingProperties) {
        return !"".equals(indexingProperties.getMongoUsername()) && !"".equals(indexingProperties.getMongoPassword()) && !"".equals(indexingProperties.getMongoAuthDb());
    }

    private void prepareSolrSetting(IndexingSettings indexingSettings, IndexingProperties indexingProperties) throws URISyntaxException, IndexingException {
        String[] instances;
        String solrInstances = indexingProperties.getSolrInstances();
        for (String instance : instances = solrInstances.trim().split(",")) {
            indexingSettings.addSolrHost(new URI(instance));
        }
    }

    private void prepareZookeeperSettings(IndexingSettings indexingSettings, IndexingProperties indexingProperties) throws IndexingException {
        String[] instances;
        String zookeeperInstances = indexingProperties.getZookeeperInstances();
        int zookeeperPort = indexingProperties.getZookeeperPortNumber();
        for (String instance : instances = zookeeperInstances.trim().split(",")) {
            indexingSettings.addZookeeperHost(new InetSocketAddress(instance, zookeeperPort));
        }
        indexingSettings.setZookeeperChroot(indexingProperties.getZookeeperChroot());
        indexingSettings.setZookeeperDefaultCollection(indexingProperties.getZookeeperDefaultCollection());
    }
}

