/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.service.utils.indexing;

import eu.europeana.cloud.service.dps.metis.indexing.TargetIndexingDatabase;
import eu.europeana.cloud.service.dps.service.utils.indexing.IndexWrapperException;
import eu.europeana.cloud.service.dps.service.utils.indexing.IndexingPropertiesTransformer;
import eu.europeana.cloud.service.dps.service.utils.indexing.IndexingSettingsGenerator;
import eu.europeana.cloud.service.web.common.properties.IndexingProperties;
import eu.europeana.indexing.Indexer;
import eu.europeana.indexing.IndexerFactory;
import eu.europeana.indexing.IndexingSettings;
import eu.europeana.indexing.exception.IndexingException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexWrapper.class);
    private static IndexWrapper instance;
    protected final IndexingProperties previewIndexingProperties;
    protected final IndexingProperties publishIndexingProperties;
    protected final Map<TargetIndexingDatabase, Indexer> indexers = new EnumMap<TargetIndexingDatabase, Indexer>(TargetIndexingDatabase.class);

    public IndexWrapper(IndexingProperties previewIndexingProperties, IndexingProperties publishIndexingProperties) {
        this.previewIndexingProperties = previewIndexingProperties;
        this.publishIndexingProperties = publishIndexingProperties;
        try {
            this.prepareIndexers();
        }
        catch (IndexingException | URISyntaxException e) {
            throw new IndexWrapperException("Unable to load indexers", (Exception)e);
        }
    }

    public IndexWrapper(Properties properties) {
        this.previewIndexingProperties = IndexingPropertiesTransformer.getIndexingPropertiesFromPropertyFile(properties, IndexingType.PREVIEW);
        this.publishIndexingProperties = IndexingPropertiesTransformer.getIndexingPropertiesFromPropertyFile(properties, IndexingType.PUBLISH);
    }

    public static synchronized IndexWrapper getInstance(IndexingProperties previewIndexingProperties, IndexingProperties publishIndexingProperties) {
        if (instance == null) {
            instance = new IndexWrapper(previewIndexingProperties, publishIndexingProperties);
        }
        return instance;
    }

    public static synchronized IndexWrapper getInstance(Properties indexingPropertyFile) {
        if (instance == null) {
            IndexingProperties previewIndexingProperties = IndexingPropertiesTransformer.getIndexingPropertiesFromPropertyFile(indexingPropertyFile, IndexingType.PREVIEW);
            IndexingProperties publishIndexingProperties = IndexingPropertiesTransformer.getIndexingPropertiesFromPropertyFile(indexingPropertyFile, IndexingType.PUBLISH);
            instance = new IndexWrapper(previewIndexingProperties, publishIndexingProperties);
        }
        return instance;
    }

    protected void prepareIndexers() throws IndexingException, URISyntaxException {
        IndexingSettingsGenerator indexingSettingsGenerator = new IndexingSettingsGenerator(this.previewIndexingProperties, this.publishIndexingProperties);
        IndexingSettings indexingSettings = indexingSettingsGenerator.generateForPreview();
        this.indexers.put(TargetIndexingDatabase.PREVIEW, new IndexerFactory(indexingSettings).getIndexer());
        indexingSettings = indexingSettingsGenerator.generateForPublish();
        this.indexers.put(TargetIndexingDatabase.PUBLISH, new IndexerFactory(indexingSettings).getIndexer());
    }

    @PreDestroy
    private void close() {
        this.indexers.values().forEach(indexer -> {
            try {
                indexer.close();
            }
            catch (IOException e) {
                LOGGER.error("Unable to close indexer", (Throwable)e);
            }
        });
    }

    public Indexer getIndexer(TargetIndexingDatabase targetIndexingDatabase) {
        return this.indexers.get(targetIndexingDatabase);
    }

    protected static enum IndexingType {
        PUBLISH,
        PREVIEW;

    }
}

