/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.service.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyManager {
    public static final String separatorChar = ",";
    public static final Logger logger = LoggerFactory.getLogger(TopologyManager.class);
    private List<String> topologies = null;

    public TopologyManager(String nameList) {
        String[] names = nameList.split(separatorChar);
        this.assertNotEmpty(names);
        this.topologies = new ArrayList<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            this.topologies.add(names[i]);
        }
        this.logResult();
    }

    private void logResult() {
        for (String topologyName : this.topologies) {
            logger.info("Topology registered -> topologyName= {}", (Object)topologyName);
        }
    }

    public List<String> getNames() {
        return this.topologies;
    }

    private void assertNotEmpty(String[] names) {
        Preconditions.checkArgument((names.length > 0 ? 1 : 0) != 0, (Object)"No registered topologies");
    }

    public boolean containsTopology(String topologyName) {
        return this.topologies.contains(topologyName);
    }
}

