/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.service.utils.validation;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.exception.DpsTaskValidationException;
import eu.europeana.cloud.service.dps.service.utils.validation.DpsTaskConstraint;
import eu.europeana.cloud.service.dps.service.utils.validation.DpsTaskFieldType;
import eu.europeana.cloud.service.dps.service.utils.validation.InputDataValueType;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.validator.routines.UrlValidator;

public class DpsTaskValidator {
    private List<DpsTaskConstraint> dpsTaskConstraints = new ArrayList<DpsTaskConstraint>();
    private String validatorName;
    private boolean revisionMustExist = false;

    public DpsTaskValidator() {
        this("Default validator");
    }

    public DpsTaskValidator(String validatorName) {
        this.validatorName = validatorName;
    }

    public DpsTaskValidator withParameter(String parameterName) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.PARAMETER).expectedName(parameterName).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public String getValidatorName() {
        return this.validatorName;
    }

    public DpsTaskValidator withParameter(String parameterName, String parameterValue) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.PARAMETER).expectedName(parameterName).expectedValue(parameterValue).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withParameter(String paramName, List allowedValues) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.PARAMETER).expectedName(paramName).expectedValue(allowedValues).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withEmptyParameter(String parameterName) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.PARAMETER).expectedName(parameterName).expectedValue("").build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withDataEntry(String inputDataName) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.INPUT_DATA).expectedName(inputDataName).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withDataEntry(String entryName, Object entryValue) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.INPUT_DATA).expectedName(entryName).expectedValue(entryValue).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withDataEntry(String entryName, InputDataValueType contentType) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.INPUT_DATA).expectedName(entryName).expectedValueType(contentType).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withName(String taskName) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.NAME).expectedName(null).expectedValue(taskName).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withAnyName() {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.NAME).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withId(long taskId) {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.ID).expectedName(null).expectedValue(taskId + "").build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withAnyId() {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.ID).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withAnyOutputRevision() {
        this.revisionMustExist = true;
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.OUTPUT_REVISION).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public DpsTaskValidator withOptionalOutputRevision() {
        DpsTaskConstraint constraint = DpsTaskConstraint.newDpsTaskConstraint().fieldType(DpsTaskFieldType.OUTPUT_REVISION).build();
        this.dpsTaskConstraints.add(constraint);
        return this;
    }

    public void validate(DpsTask task) throws DpsTaskValidationException {
        for (DpsTaskConstraint re : this.dpsTaskConstraints) {
            DpsTaskFieldType fieldType = re.getFieldType();
            if (fieldType.equals((Object)DpsTaskFieldType.NAME)) {
                this.validateName(task, re);
                continue;
            }
            if (fieldType.equals((Object)DpsTaskFieldType.PARAMETER)) {
                this.validateParameter(task, re);
                continue;
            }
            if (fieldType.equals((Object)DpsTaskFieldType.INPUT_DATA)) {
                this.validateInputData(task, re);
                continue;
            }
            if (fieldType.equals((Object)DpsTaskFieldType.ID)) {
                this.validateId(task, re);
                continue;
            }
            if (!fieldType.equals((Object)DpsTaskFieldType.OUTPUT_REVISION)) continue;
            this.validateOutputRevision(task, this.revisionMustExist);
        }
    }

    private void validateName(DpsTask task, DpsTaskConstraint constraint) throws DpsTaskValidationException {
        String taskName = task.getTaskName();
        if (constraint.getExpectedValue() == null && taskName != null) {
            return;
        }
        if ("".equals(constraint.getExpectedValue()) && "".equals(taskName)) {
            return;
        }
        if (constraint.getExpectedValue().equals(taskName)) {
            return;
        }
        throw new DpsTaskValidationException("Task name is not valid.");
    }

    private void validateParameter(DpsTask task, DpsTaskConstraint constraint) throws DpsTaskValidationException {
        String parameterValue = task.getParameter(constraint.getExpectedName());
        if (parameterValue == null) {
            throw new DpsTaskValidationException("Expected parameter does not exist in dpsTask. Parameter name: " + constraint.getExpectedName());
        }
        Object expectedValue = constraint.getExpectedValue();
        if (expectedValue == null) {
            return;
        }
        if (expectedValue instanceof List) {
            List ls = (List)expectedValue;
            if (ls.contains(parameterValue)) {
                return;
            }
        } else {
            if ("".equals(expectedValue) && "".equals(parameterValue)) {
                return;
            }
            if (parameterValue.equals(expectedValue)) {
                return;
            }
        }
        throw new DpsTaskValidationException("Parameter does not meet constraints. Parameter name: " + constraint.getExpectedName());
    }

    private void validateInputData(DpsTask task, DpsTaskConstraint constraint) throws DpsTaskValidationException {
        InputDataType dataType;
        try {
            dataType = InputDataType.valueOf((String)constraint.getExpectedName());
        }
        catch (IllegalArgumentException e) {
            throw new DpsTaskValidationException("Input data is not valid.");
        }
        List expectedInputData = task.getDataEntry(dataType);
        if (expectedInputData == null) {
            throw new DpsTaskValidationException("Expected parameter does not exist in dpsTask. Parameter name: " + constraint.getExpectedName());
        }
        if (constraint.getExpectedValueType() != null) {
            this.validateInputDataContent(expectedInputData, constraint);
        }
        if (constraint.getExpectedValue() == null) {
            return;
        }
        if ("".equals(constraint.getExpectedValue()) && expectedInputData.isEmpty()) {
            return;
        }
        if (expectedInputData.equals(constraint.getExpectedValue())) {
            return;
        }
        throw new DpsTaskValidationException("Input data is not valid.");
    }

    private void validateInputDataContent(List<String> expectedInputData, DpsTaskConstraint constraint) throws DpsTaskValidationException {
        for (String expectedInputDataValue : expectedInputData) {
            try {
                if (constraint.getExpectedValueType().equals((Object)InputDataValueType.LINK_TO_FILE)) {
                    this.tryValidateFileUrl(expectedInputDataValue);
                    continue;
                }
                if (constraint.getExpectedValueType().equals((Object)InputDataValueType.LINK_TO_DATASET)) {
                    this.tryValidateDatasetUrl(expectedInputDataValue);
                    continue;
                }
                if (!constraint.getExpectedValueType().equals((Object)InputDataValueType.LINK_TO_EXTERNAL_URL)) continue;
                this.tryValidateResourceUrl(expectedInputDataValue);
            }
            catch (MalformedURLException e) {
                throw new DpsTaskValidationException("Wrong input data: " + expectedInputDataValue);
            }
        }
    }

    private void tryValidateResourceUrl(String expectedInputDataValue) throws DpsTaskValidationException {
        UrlValidator urlValidator = new UrlValidator();
        if (!urlValidator.isValid(expectedInputDataValue)) {
            throw new DpsTaskValidationException("Wrong input data: " + expectedInputDataValue);
        }
    }

    private void tryValidateFileUrl(String expectedInputDataValue) throws MalformedURLException, DpsTaskValidationException {
        UrlParser parser = new UrlParser(expectedInputDataValue);
        if (!parser.isUrlToRepresentationVersionFile()) {
            throw new DpsTaskValidationException("Wrong input data: " + expectedInputDataValue);
        }
    }

    private void tryValidateDatasetUrl(String expectedInputDataValue) throws MalformedURLException, DpsTaskValidationException {
        UrlParser parser = new UrlParser(expectedInputDataValue);
        if (!parser.isUrlToDataset()) {
            throw new DpsTaskValidationException("Wrong input data: " + expectedInputDataValue);
        }
    }

    private void validateId(DpsTask task, DpsTaskConstraint constraint) throws DpsTaskValidationException {
        long taskId = task.getTaskId();
        if (constraint.getExpectedValue() == null) {
            return;
        }
        if (constraint.getExpectedValue().equals(taskId + "")) {
            return;
        }
        throw new DpsTaskValidationException("Task id is not valid.");
    }

    private void validateOutputRevision(DpsTask task, boolean revisionMustExist) throws DpsTaskValidationException {
        Revision outputRevision = task.getOutputRevision();
        if (revisionMustExist) {
            if (outputRevision == null) {
                throw new DpsTaskValidationException("Output Revision should not be null!. It is required for this task");
            }
            this.checkOutputRevisionContent(outputRevision);
        } else if (outputRevision != null) {
            this.checkOutputRevisionContent(outputRevision);
        }
    }

    private void checkOutputRevisionContent(Revision outputRevision) throws DpsTaskValidationException {
        if (outputRevision.getRevisionName() == null || outputRevision.getRevisionProviderId() == null) {
            throw new DpsTaskValidationException("Revision name and revision provider has to be not null");
        }
        if (outputRevision.getRevisionName().matches("\\s*") || outputRevision.getRevisionProviderId().matches("\\s*")) {
            throw new DpsTaskValidationException("Revision name and revision provider has to be non empty");
        }
    }
}

