/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.service.utils.indexing;

import eu.europeana.cloud.service.dps.service.utils.validation.TargetIndexingEnvironment;
import eu.europeana.indexing.IndexingSettings;
import eu.europeana.indexing.exception.IndexingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingSettingsGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingSettingsGenerator.class);
    public static final String PREVIEW_PREFIX = "preview";
    public static final String PUBLISH_PREFIX = "publish";
    public static final String MONGO_INSTANCES = "mongo.instances";
    public static final String MONGO_PORT_NUMBER = "mongo.portNumber";
    public static final String MONGO_DB_NAME = "mongo.dbName";
    public static final String MONGO_USERNAME = "mongo.username";
    public static final String MONGO_SECRET = "mongo.password";
    public static final String MONGO_USE_SSL = "mongo.useSSL";
    public static final String MONGO_AUTH_DB = "mongo.authDB";
    public static final String SOLR_INSTANCES = "solr.instances";
    public static final String ZOOKEEPER_INSTANCES = "zookeeper.instances";
    public static final String ZOOKEEPER_PORT_NUMBER = "zookeeper.portNumber";
    public static final String ZOOKEEPER_CHROOT = "zookeeper.chroot";
    public static final String ZOOKEEPER_DEFAULT_COLLECTION = "zookeeper.defaultCollection";
    public static final String DELIMITER = ".";
    private Properties properties;
    private TargetIndexingEnvironment environmentPrefix;

    public IndexingSettingsGenerator(TargetIndexingEnvironment environment, Properties properties) {
        this.environmentPrefix = environment;
        this.properties = properties;
    }

    public IndexingSettingsGenerator(Properties properties) {
        this(TargetIndexingEnvironment.DEFAULT, properties);
    }

    public IndexingSettings generateForPreview() throws IndexingException, URISyntaxException {
        if (!this.isDefinedFor(this.preparePreviewPrefix())) {
            return null;
        }
        IndexingSettings indexingSettings = new IndexingSettings();
        this.prepareSettingFor(this.preparePreviewPrefix(), indexingSettings);
        return indexingSettings;
    }

    public IndexingSettings generateForPublish() throws IndexingException, URISyntaxException {
        if (!this.isDefinedFor(this.preparePublishPrefix())) {
            return null;
        }
        IndexingSettings indexingSettings = new IndexingSettings();
        this.prepareSettingFor(this.preparePublishPrefix(), indexingSettings);
        return indexingSettings;
    }

    private boolean isDefinedFor(String prefix) {
        return this.properties.get(prefix + DELIMITER + MONGO_INSTANCES) != null;
    }

    private String preparePreviewPrefix() {
        if (this.environmentPrefix != TargetIndexingEnvironment.DEFAULT) {
            return (Object)((Object)this.environmentPrefix) + DELIMITER + PREVIEW_PREFIX;
        }
        return PREVIEW_PREFIX;
    }

    private String preparePublishPrefix() {
        if (this.environmentPrefix != TargetIndexingEnvironment.DEFAULT) {
            return (Object)((Object)this.environmentPrefix) + DELIMITER + PUBLISH_PREFIX;
        }
        return PUBLISH_PREFIX;
    }

    private void prepareSettingFor(String environment, IndexingSettings indexingSettings) throws IndexingException, URISyntaxException {
        this.prepareMongoSettings(indexingSettings, environment);
        this.prepareSolrSetting(indexingSettings, environment);
        this.prepareZookeeperSettings(indexingSettings, environment);
    }

    private void prepareMongoSettings(IndexingSettings indexingSettings, String prefix) throws IndexingException {
        String[] instances;
        String mongoInstances = this.properties.get(prefix + DELIMITER + MONGO_INSTANCES).toString();
        int mongoPort = Integer.parseInt(this.properties.get(prefix + DELIMITER + MONGO_PORT_NUMBER).toString());
        for (String instance : instances = mongoInstances.trim().split(",")) {
            indexingSettings.addMongoHost(new InetSocketAddress(instance, mongoPort));
        }
        indexingSettings.setMongoDatabaseName(this.properties.get(prefix + DELIMITER + MONGO_DB_NAME).toString());
        if (this.mongoCredentialsProvidedFor(prefix)) {
            indexingSettings.setMongoCredentials(this.properties.get(prefix + DELIMITER + MONGO_USERNAME).toString(), this.properties.get(prefix + DELIMITER + MONGO_SECRET).toString(), this.properties.get(prefix + DELIMITER + MONGO_AUTH_DB).toString());
        } else {
            LOGGER.info("Mongo credentials not provided");
        }
        if (this.properties.getProperty(prefix + DELIMITER + MONGO_USE_SSL) != null && this.properties.getProperty(prefix + DELIMITER + MONGO_USE_SSL).equalsIgnoreCase("true")) {
            indexingSettings.setMongoEnableSsl();
        }
    }

    private boolean mongoCredentialsProvidedFor(String prefix) {
        return !"".equals(this.properties.get(prefix + DELIMITER + MONGO_USERNAME)) && !"".equals(this.properties.get(prefix + DELIMITER + MONGO_SECRET)) && !"".equals(this.properties.get(prefix + DELIMITER + MONGO_AUTH_DB));
    }

    private void prepareSolrSetting(IndexingSettings indexingSettings, String prefix) throws URISyntaxException, IndexingException {
        String[] instances;
        String solrInstances = this.properties.get(prefix + DELIMITER + SOLR_INSTANCES).toString();
        for (String instance : instances = solrInstances.trim().split(",")) {
            indexingSettings.addSolrHost(new URI(instance));
        }
    }

    private void prepareZookeeperSettings(IndexingSettings indexingSettings, String prefix) throws IndexingException {
        String[] instances;
        String zookeeperInstances = this.properties.get(prefix + DELIMITER + ZOOKEEPER_INSTANCES).toString();
        int zookeeperPort = Integer.parseInt(this.properties.get(prefix + DELIMITER + ZOOKEEPER_PORT_NUMBER).toString());
        for (String instance : instances = zookeeperInstances.trim().split(",")) {
            indexingSettings.addZookeeperHost(new InetSocketAddress(instance, zookeeperPort));
        }
        indexingSettings.setZookeeperChroot(this.properties.getProperty(prefix + DELIMITER + ZOOKEEPER_CHROOT));
        indexingSettings.setZookeeperDefaultCollection(this.properties.getProperty(prefix + DELIMITER + ZOOKEEPER_DEFAULT_COLLECTION));
    }
}

