/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.transport;

import java.net.URI;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class HttpsRedirectWebFilter
implements WebFilter {
    private PortMapper portMapper = new PortMapperImpl();
    private ServerWebExchangeMatcher requiresHttpsRedirectMatcher = ServerWebExchangeMatchers.anyExchange();
    private final ServerRedirectStrategy redirectStrategy = new DefaultServerRedirectStrategy();

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return Mono.just((Object)exchange2).filter(this::isInsecure).flatMap(this.requiresHttpsRedirectMatcher::matches).filter(matchResult -> matchResult.isMatch()).switchIfEmpty(chain.filter(exchange2).then(Mono.empty())).map(matchResult -> this.createRedirectUri(exchange2)).flatMap(uri -> this.redirectStrategy.sendRedirect(exchange2, (URI)uri));
    }

    public void setPortMapper(PortMapper portMapper) {
        Assert.notNull((Object)portMapper, "portMapper cannot be null");
        this.portMapper = portMapper;
    }

    public void setRequiresHttpsRedirectMatcher(ServerWebExchangeMatcher requiresHttpsRedirectMatcher) {
        Assert.notNull((Object)requiresHttpsRedirectMatcher, "requiresHttpsRedirectMatcher cannot be null");
        this.requiresHttpsRedirectMatcher = requiresHttpsRedirectMatcher;
    }

    private boolean isInsecure(ServerWebExchange exchange2) {
        return !"https".equals(exchange2.getRequest().getURI().getScheme());
    }

    private URI createRedirectUri(ServerWebExchange exchange2) {
        int port = exchange2.getRequest().getURI().getPort();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri(exchange2.getRequest().getURI());
        if (port > 0) {
            Integer httpsPort = this.portMapper.lookupHttpsPort(port);
            if (httpsPort == null) {
                throw new IllegalStateException("HTTP Port '" + port + "' does not have a corresponding HTTPS Port");
            }
            builder.port(httpsPort);
        }
        return builder.scheme("https").build().toUri();
    }
}

