/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.List;
import org.springframework.aop.config.AbstractInterceptorDrivenBeanDefinitionDecorator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class InternalInterceptMethodsBeanDefinitionDecorator
extends AbstractInterceptorDrivenBeanDefinitionDecorator {
    static final String ATT_METHOD = "method";
    static final String ATT_ACCESS = "access";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";

    InternalInterceptMethodsBeanDefinitionDecorator() {
    }

    @Override
    protected BeanDefinition createInterceptorDefinition(Node node) {
        Element interceptMethodsElt = (Element)node;
        BeanDefinitionBuilder interceptor = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityInterceptor.class);
        interceptor.setAutowireMode(2);
        String accessManagerId = interceptMethodsElt.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText(accessManagerId)) {
            accessManagerId = "org.springframework.security.defaultMethodAccessManager";
        }
        interceptor.addPropertyValue("accessDecisionManager", new RuntimeBeanReference(accessManagerId));
        interceptor.addPropertyValue("authenticationManager", new RuntimeBeanReference("org.springframework.security.authenticationManager"));
        String parentBeanClass = ((Element)node.getParentNode()).getAttribute("class");
        List<Element> methods = DomUtils.getChildElementsByTagName(interceptMethodsElt, "protect");
        ManagedMap<String, AbstractBeanDefinition> mappings = new ManagedMap<String, AbstractBeanDefinition>();
        for (Element protectmethodElt : methods) {
            BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
            attributeBuilder.setFactoryMethod("createListFromCommaDelimitedString");
            attributeBuilder.addConstructorArgValue(protectmethodElt.getAttribute(ATT_ACCESS));
            String methodName = protectmethodElt.getAttribute(ATT_METHOD);
            if (methodName.lastIndexOf(".") == -1 && parentBeanClass != null && !"".equals(parentBeanClass)) {
                methodName = parentBeanClass + "." + methodName;
            }
            mappings.put(methodName, attributeBuilder.getBeanDefinition());
        }
        RootBeanDefinition metadataSource = new RootBeanDefinition(MapBasedMethodSecurityMetadataSource.class);
        metadataSource.getConstructorArgumentValues().addGenericArgumentValue(mappings);
        interceptor.addPropertyValue("securityMetadataSource", metadataSource);
        return interceptor.getBeanDefinition();
    }
}

