/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.lang.reflect.Array;

public class GrowableStringArray {
    public static final int DEFAULT_SIZE = 8;
    private int m_countLimit;
    private int m_countPresent;
    private int m_maximumGrowth;
    private String[] m_baseArray;

    public GrowableStringArray(int size, int growth) {
        String[] array = new String[size];
        this.m_countLimit = size;
        this.m_maximumGrowth = growth;
        this.m_baseArray = array;
    }

    public GrowableStringArray(int size) {
        this(size, Integer.MAX_VALUE);
    }

    public GrowableStringArray() {
        this(8);
    }

    public GrowableStringArray(GrowableStringArray base) {
        this(base.m_countLimit, base.m_maximumGrowth);
        System.arraycopy(base.m_baseArray, 0, this.m_baseArray, 0, base.m_countPresent);
        this.m_countPresent = base.m_countPresent;
    }

    private void resizeCopy(Object base, Object grown) {
        System.arraycopy(base, 0, grown, 0, Array.getLength(base));
    }

    private void discardValues(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.m_baseArray[i] = null;
        }
    }

    private void growArray(int required) {
        int size = Math.max(required, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        String[] grown = new String[size];
        this.resizeCopy(this.m_baseArray, grown);
        this.m_countLimit = size;
        this.m_baseArray = grown;
    }

    public final void ensureCapacity(int min2) {
        if (min2 > this.m_countLimit) {
            this.growArray(min2);
        }
    }

    public void set(int index, String value) {
        if (index >= this.m_countPresent) {
            throw new IllegalArgumentException("Index value out of range");
        }
        this.m_baseArray[index] = value;
    }

    public void add(String value) {
        int index = this.getAddIndex();
        this.m_baseArray[index] = value;
    }

    public void addAll(String[] values) {
        this.ensureCapacity(this.m_countPresent + values.length);
        for (int i = 0; i < values.length; ++i) {
            this.m_baseArray[this.m_countPresent++] = values[i];
        }
    }

    public void remove(int count) {
        int start = this.m_countPresent - count;
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to remove too many values from array");
        }
        this.discardValues(start, this.m_countPresent);
        this.m_countPresent = start;
    }

    public String get(int index) {
        if (this.m_countPresent > index) {
            return this.m_baseArray[index];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to access past end of array");
    }

    public String[] toArray() {
        String[] copy = new String[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, copy, 0, this.m_countPresent);
        return copy;
    }

    public Object clone() {
        return new GrowableStringArray(this);
    }

    private int getAddIndex() {
        int index = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return index;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.discardValues(0, this.m_countPresent);
        this.m_countPresent = 0;
    }
}

