/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class TypedArrayMapper
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private static final Object[] DUMMY_ARRAY = new Object[0];
    private String m_uri;
    private int m_index;
    private String m_name;
    private Object[] m_baseArray;
    private ArrayList m_holder;

    public TypedArrayMapper(String uri, int index, String name, String type) {
        this.m_uri = uri;
        this.m_index = index;
        this.m_name = name;
        int dimen = 0;
        while (type.endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
            ++dimen;
        }
        try {
            Class<?> clas = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    clas = loader.loadClass(type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clas == null) {
                clas = UnmarshallingContext.class.getClassLoader().loadClass(type);
            }
            int[] dimens = new int[dimen];
            this.m_baseArray = (Object[])Array.newInstance(clas, dimens);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Error loading array item class " + type + ": " + e.getMessage());
        }
    }

    public TypedArrayMapper(String type) {
        this(null, 0, null, type);
    }

    @Override
    public boolean isExtension(String mapname) {
        return false;
    }

    @Override
    public void marshal(Object obj, IMarshallingContext ictx) throws JiBXException {
        if (obj == null) {
            if (this.m_name == null) {
                throw new JiBXException("null array not allowed without wrapper");
            }
        } else {
            if (!(ictx instanceof MarshallingContext)) {
                throw new JiBXException("Marshalling context not of expected type");
            }
            Class<?> clas = obj.getClass();
            if (!clas.isArray()) {
                throw new JiBXException("Invalid object type for marshaller");
            }
            MarshallingContext ctx = (MarshallingContext)ictx;
            Object[] array = (Object[])obj;
            if (this.m_name != null) {
                ctx.startTag(this.m_index, this.m_name);
            }
            for (int i = 0; i < array.length; ++i) {
                Object item = array[i];
                if (item == null) {
                    throw new JiBXException("Null value at offset " + i + " not supported");
                }
                if (!(item instanceof IMarshallable)) {
                    throw new JiBXException("Array item of type " + item.getClass().getName() + " does not implement org.jibx.runtime.IMarshallable");
                }
                ((IMarshallable)item).marshal(ctx);
            }
            if (this.m_name != null) {
                ctx.endTag(this.m_index, this.m_name);
            }
        }
    }

    @Override
    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.m_uri, this.m_name);
    }

    @Override
    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (this.m_name != null) {
            if (ctx.isAt(this.m_uri, this.m_name)) {
                ctx.parsePastStartTag(this.m_uri, this.m_name);
            } else {
                return null;
            }
        }
        if (this.m_holder == null) {
            this.m_holder = new ArrayList();
        }
        while (!ctx.isEnd()) {
            Object item = ctx.unmarshalElement();
            this.m_holder.add(item);
        }
        if (this.m_name != null) {
            ctx.parsePastEndTag(this.m_uri, this.m_name);
        }
        Object[] result = this.m_holder.toArray(this.m_baseArray);
        this.m_holder.clear();
        return result;
    }
}

