/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.subscription;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.subscription.TopicFilter;

public class PatternTopicFilter
implements TopicFilter {
    private final Pattern pattern;
    private final Set<String> topics = new HashSet<String>();

    public PatternTopicFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Set<TopicPartition> getAllSubscribedPartitions(Consumer<?, ?> consumer) {
        this.topics.clear();
        HashSet<TopicPartition> allPartitions = new HashSet<TopicPartition>();
        for (Map.Entry<String, List<PartitionInfo>> entry : consumer.listTopics().entrySet()) {
            if (!this.pattern.matcher(entry.getKey()).matches()) continue;
            for (PartitionInfo partitionInfo : entry.getValue()) {
                allPartitions.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
                this.topics.add(partitionInfo.topic());
            }
        }
        return allPartitions;
    }

    @Override
    public String getTopicsString() {
        return String.join((CharSequence)",", this.topics);
    }

    public String getTopicsPattern() {
        return this.pattern.pattern();
    }
}

