/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.bolt.selector;

import org.apache.storm.kafka.bolt.selector.KafkaTopicSelector;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldIndexTopicSelector
implements KafkaTopicSelector {
    private static final long serialVersionUID = -3830575380208166367L;
    private static final Logger LOG = LoggerFactory.getLogger(FieldIndexTopicSelector.class);
    private final int fieldIndex;
    private final String defaultTopicName;

    public FieldIndexTopicSelector(int fieldIndex, String defaultTopicName) {
        this.fieldIndex = fieldIndex;
        if (fieldIndex < 0) {
            throw new IllegalArgumentException("fieldIndex cannot be negative");
        }
        this.defaultTopicName = defaultTopicName;
    }

    @Override
    public String getTopic(Tuple tuple) {
        if (this.fieldIndex < tuple.size()) {
            return tuple.getString(this.fieldIndex);
        }
        LOG.warn("Field index {} is out of bounds. Using default topic {}", (Object)this.fieldIndex, (Object)this.defaultTopicName);
        return this.defaultTopicName;
    }
}

