/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.util.Queue;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.Send;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSend
implements Send {
    private static final Logger log = LoggerFactory.getLogger(MultiSend.class);
    private final String dest;
    private final Queue<Send> sendQueue;
    private final long size;
    private long totalWritten = 0L;
    private Send current;

    public MultiSend(String dest, Queue<Send> sends) {
        this.dest = dest;
        this.sendQueue = sends;
        long size = 0L;
        for (Send send : sends) {
            size += send.size();
        }
        this.size = size;
        this.current = this.sendQueue.poll();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String destination() {
        return this.dest;
    }

    @Override
    public boolean completed() {
        return this.current == null;
    }

    int numResidentSends() {
        int count = 0;
        if (this.current != null) {
            ++count;
        }
        return count += this.sendQueue.size();
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        boolean sendComplete;
        if (this.completed()) {
            throw new KafkaException("This operation cannot be invoked on a complete request.");
        }
        int totalWrittenPerCall = 0;
        do {
            long written = this.current.writeTo(channel);
            totalWrittenPerCall = (int)((long)totalWrittenPerCall + written);
            sendComplete = this.current.completed();
            if (!sendComplete) continue;
            this.current = this.sendQueue.poll();
        } while (!this.completed() && sendComplete);
        this.totalWritten += (long)totalWrittenPerCall;
        if (this.completed() && this.totalWritten != this.size) {
            log.error("mismatch in sending bytes over socket; expected: " + this.size + " actual: " + this.totalWritten);
        }
        log.trace("Bytes written as part of multi-send call: {}, total bytes written so far: {}, expected bytes to write: {}", totalWrittenPerCall, this.totalWritten, this.size);
        return totalWrittenPerCall;
    }
}

