/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics
implements Closeable {
    private final MetricConfig config;
    private final ConcurrentMap<MetricName, KafkaMetric> metrics;
    private final ConcurrentMap<String, Sensor> sensors;
    private final ConcurrentMap<Sensor, List<Sensor>> childrenSensors;
    private final List<MetricsReporter> reporters;
    private final Time time;
    private final ScheduledThreadPoolExecutor metricsScheduler;
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);

    public Metrics() {
        this(new MetricConfig());
    }

    public Metrics(Time time) {
        this(new MetricConfig(), new ArrayList<MetricsReporter>(0), time);
    }

    public Metrics(MetricConfig defaultConfig, Time time) {
        this(defaultConfig, new ArrayList<MetricsReporter>(0), time);
    }

    public Metrics(MetricConfig defaultConfig) {
        this(defaultConfig, new ArrayList<MetricsReporter>(0), Time.SYSTEM);
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time) {
        this(defaultConfig, reporters, time, false);
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time, boolean enableExpiration) {
        this.config = defaultConfig;
        this.sensors = new ConcurrentHashMap<String, Sensor>();
        this.metrics = new ConcurrentHashMap<MetricName, KafkaMetric>();
        this.childrenSensors = new ConcurrentHashMap<Sensor, List<Sensor>>();
        this.reporters = Utils.notNull(reporters);
        this.time = time;
        for (MetricsReporter reporter : reporters) {
            reporter.init(new ArrayList<KafkaMetric>());
        }
        if (enableExpiration) {
            this.metricsScheduler = new ScheduledThreadPoolExecutor(1);
            this.metricsScheduler.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    return KafkaThread.daemon("SensorExpiryThread", runnable);
                }
            });
            this.metricsScheduler.scheduleAtFixedRate(new ExpireSensorTask(), 30L, 30L, TimeUnit.SECONDS);
        } else {
            this.metricsScheduler = null;
        }
        this.addMetric(this.metricName("count", "kafka-metrics-count", "total number of registered metrics"), new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return Metrics.this.metrics.size();
            }
        });
    }

    public MetricName metricName(String name, String group, String description, Map<String, String> tags) {
        LinkedHashMap<String, String> combinedTag = new LinkedHashMap<String, String>(this.config.tags());
        combinedTag.putAll(tags);
        return new MetricName(name, group, description, combinedTag);
    }

    public MetricName metricName(String name, String group, String description) {
        return this.metricName(name, group, description, new HashMap<String, String>());
    }

    public MetricName metricName(String name, String group) {
        return this.metricName(name, group, "", new HashMap<String, String>());
    }

    public MetricName metricName(String name, String group, String description, String ... keyValue) {
        return this.metricName(name, group, description, Metrics.getTags(keyValue));
    }

    public MetricName metricName(String name, String group, Map<String, String> tags) {
        return this.metricName(name, group, "", tags);
    }

    private static Map<String, String> getTags(String ... keyValue) {
        if (keyValue.length % 2 != 0) {
            throw new IllegalArgumentException("keyValue needs to be specified in pairs");
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        for (int i = 0; i < keyValue.length; i += 2) {
            tags.put(keyValue[i], keyValue[i + 1]);
        }
        return tags;
    }

    public static String toHtmlTable(String domain, Iterable<MetricNameTemplate> allMetrics) {
        TreeMap beansAndAttributes = new TreeMap();
        Metrics metrics = new Metrics();
        Object object = null;
        try {
            for (MetricNameTemplate template : allMetrics) {
                Map attrAndDesc;
                LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
                for (String s2 : template.tags()) {
                    tags.put(s2, "{" + s2 + "}");
                }
                MetricName metricName = metrics.metricName(template.name(), template.group(), template.description(), tags);
                String mBeanName = JmxReporter.getMBeanName(domain, metricName);
                if (!beansAndAttributes.containsKey(mBeanName)) {
                    beansAndAttributes.put(mBeanName, new TreeMap());
                }
                if (!(attrAndDesc = (Map)beansAndAttributes.get(mBeanName)).containsKey(template.name())) {
                    attrAndDesc.put(template.name(), template.description());
                    continue;
                }
                throw new IllegalArgumentException("mBean '" + mBeanName + "' attribute '" + template.name() + "' is defined twice.");
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (metrics != null) {
                if (object != null) {
                    try {
                        metrics.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    metrics.close();
                }
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        for (Map.Entry entry : beansAndAttributes.entrySet()) {
            b.append("<tr>\n");
            b.append("<td colspan=3 class=\"mbeanName\" style=\"background-color:#ccc; font-weight: bold;\">");
            b.append((String)entry.getKey());
            b.append("</td>");
            b.append("</tr>\n");
            b.append("<tr>\n");
            b.append("<th style=\"width: 90px\"></th>\n");
            b.append("<th>Attribute name</th>\n");
            b.append("<th>Description</th>\n");
            b.append("</tr>\n");
            for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                b.append("<tr>\n");
                b.append("<td></td>");
                b.append("<td>");
                b.append((String)e2.getKey());
                b.append("</td>");
                b.append("<td>");
                b.append((String)e2.getValue());
                b.append("</td>");
                b.append("</tr>\n");
            }
        }
        b.append("</tbody></table>");
        return b.toString();
    }

    public MetricConfig config() {
        return this.config;
    }

    public Sensor getSensor(String name) {
        return (Sensor)this.sensors.get(Utils.notNull(name));
    }

    public Sensor sensor(String name) {
        return this.sensor(name, Sensor.RecordingLevel.INFO);
    }

    public Sensor sensor(String name, Sensor.RecordingLevel recordingLevel) {
        return this.sensor(name, null, recordingLevel, (Sensor[])null);
    }

    public Sensor sensor(String name, Sensor ... parents) {
        return this.sensor(name, Sensor.RecordingLevel.INFO, parents);
    }

    public Sensor sensor(String name, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.sensor(name, null, recordingLevel, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, Sensor ... parents) {
        return this.sensor(name, config, Sensor.RecordingLevel.INFO, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.sensor(name, config, Long.MAX_VALUE, recordingLevel, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, long inactiveSensorExpirationTimeSeconds, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        Sensor s2 = this.getSensor(name);
        if (s2 == null) {
            s2 = new Sensor(this, name, parents, config == null ? this.config : config, this.time, inactiveSensorExpirationTimeSeconds, recordingLevel);
            this.sensors.put(name, s2);
            if (parents != null) {
                for (Sensor parent : parents) {
                    ArrayList<Sensor> children = (ArrayList<Sensor>)this.childrenSensors.get(parent);
                    if (children == null) {
                        children = new ArrayList<Sensor>();
                        this.childrenSensors.put(parent, children);
                    }
                    children.add(s2);
                }
            }
            log.debug("Added sensor with name {}", (Object)name);
        }
        return s2;
    }

    public synchronized Sensor sensor(String name, MetricConfig config, long inactiveSensorExpirationTimeSeconds, Sensor ... parents) {
        return this.sensor(name, config, inactiveSensorExpirationTimeSeconds, Sensor.RecordingLevel.INFO, parents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSensor(String name) {
        Sensor sensor = (Sensor)this.sensors.get(name);
        if (sensor != null) {
            List childSensors = null;
            Sensor sensor2 = sensor;
            synchronized (sensor2) {
                Metrics metrics = this;
                synchronized (metrics) {
                    if (this.sensors.remove(name, sensor)) {
                        for (KafkaMetric metric : sensor.metrics()) {
                            this.removeMetric(metric.metricName());
                        }
                        log.debug("Removed sensor with name {}", (Object)name);
                        childSensors = (List)this.childrenSensors.remove(sensor);
                    }
                }
            }
            if (childSensors != null) {
                for (Sensor childSensor : childSensors) {
                    this.removeSensor(childSensor.name());
                }
            }
        }
    }

    public void addMetric(MetricName metricName, Measurable measurable) {
        this.addMetric(metricName, (MetricConfig)null, measurable);
    }

    public void addMetric(MetricName metricName, MetricConfig config, Measurable measurable) {
        this.addMetric(metricName, config, (MetricValueProvider<?>)measurable);
    }

    public void addMetric(MetricName metricName, MetricConfig config, MetricValueProvider<?> metricValueProvider) {
        KafkaMetric m3 = new KafkaMetric(new Object(), Utils.notNull(metricName), Utils.notNull(metricValueProvider), config == null ? this.config : config, this.time);
        this.registerMetric(m3);
    }

    public void addMetric(MetricName metricName, MetricValueProvider<?> metricValueProvider) {
        this.addMetric(metricName, null, metricValueProvider);
    }

    public synchronized KafkaMetric removeMetric(MetricName metricName) {
        KafkaMetric metric = (KafkaMetric)this.metrics.remove(metricName);
        if (metric != null) {
            for (MetricsReporter reporter : this.reporters) {
                reporter.metricRemoval(metric);
            }
        }
        return metric;
    }

    public synchronized void addReporter(MetricsReporter reporter) {
        Utils.notNull(reporter).init(new ArrayList<KafkaMetric>(this.metrics.values()));
        this.reporters.add(reporter);
    }

    public synchronized void removeReporter(MetricsReporter reporter) {
        if (this.reporters.remove(reporter)) {
            reporter.close();
        }
    }

    synchronized void registerMetric(KafkaMetric metric) {
        MetricName metricName = metric.metricName();
        if (this.metrics.containsKey(metricName)) {
            throw new IllegalArgumentException("A metric named '" + metricName + "' already exists, can't register another one.");
        }
        this.metrics.put(metricName, metric);
        for (MetricsReporter reporter : this.reporters) {
            reporter.metricChange(metric);
        }
    }

    public Map<MetricName, KafkaMetric> metrics() {
        return this.metrics;
    }

    public List<MetricsReporter> reporters() {
        return this.reporters;
    }

    public KafkaMetric metric(MetricName metricName) {
        return (KafkaMetric)this.metrics.get(metricName);
    }

    Map<Sensor, List<Sensor>> childrenSensors() {
        return Collections.unmodifiableMap(this.childrenSensors);
    }

    public MetricName metricInstance(MetricNameTemplate template, String ... keyValue) {
        return this.metricInstance(template, Metrics.getTags(keyValue));
    }

    public MetricName metricInstance(MetricNameTemplate template, Map<String, String> tags) {
        HashSet<String> runtimeTagKeys = new HashSet<String>(tags.keySet());
        runtimeTagKeys.addAll(this.config().tags().keySet());
        Set<String> templateTagKeys = template.tags();
        if (!runtimeTagKeys.equals(templateTagKeys)) {
            throw new IllegalArgumentException("For '" + template.name() + "', runtime-defined metric tags do not match the tags in the template. " + "Runtime = " + ((Object)runtimeTagKeys).toString() + " Template = " + templateTagKeys.toString());
        }
        return this.metricName(template.name(), template.group(), template.description(), tags);
    }

    @Override
    public void close() {
        if (this.metricsScheduler != null) {
            this.metricsScheduler.shutdown();
            try {
                this.metricsScheduler.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        for (MetricsReporter reporter : this.reporters) {
            reporter.close();
        }
    }

    class ExpireSensorTask
    implements Runnable {
        ExpireSensorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (Map.Entry sensorEntry : Metrics.this.sensors.entrySet()) {
                Sensor sensor = (Sensor)sensorEntry.getValue();
                synchronized (sensor) {
                    if (((Sensor)sensorEntry.getValue()).hasExpired()) {
                        log.debug("Removing expired sensor {}", sensorEntry.getKey());
                        Metrics.this.removeSensor((String)sensorEntry.getKey());
                    }
                }
            }
        }
    }
}

