/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ExceptionTable
extends Attribute {
    private int[] exceptionIndexTable;

    public ExceptionTable(ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(int name_index, int length, int[] exceptionIndexTable, ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.exceptionIndexTable = exceptionIndexTable != null ? exceptionIndexTable : new int[]{};
    }

    ExceptionTable(int nameIndex, int length, DataInput input, ConstantPool constantPool) throws IOException {
        this(nameIndex, length, (int[])null, constantPool);
        int number_of_exceptions = input.readUnsignedShort();
        this.exceptionIndexTable = new int[number_of_exceptions];
        for (int i = 0; i < number_of_exceptions; ++i) {
            this.exceptionIndexTable[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitExceptionTable(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.exceptionIndexTable.length);
        for (int index : this.exceptionIndexTable) {
            file.writeShort(index);
        }
    }

    public int[] getExceptionIndexTable() {
        return this.exceptionIndexTable;
    }

    public int getNumberOfExceptions() {
        return this.exceptionIndexTable == null ? 0 : this.exceptionIndexTable.length;
    }

    public String[] getExceptionNames() {
        String[] names = new String[this.exceptionIndexTable.length];
        for (int i = 0; i < this.exceptionIndexTable.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7).replace('/', '.');
        }
        return names;
    }

    public void setExceptionIndexTable(int[] exceptionIndexTable) {
        this.exceptionIndexTable = exceptionIndexTable != null ? exceptionIndexTable : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Exceptions: ");
        for (int i = 0; i < this.exceptionIndexTable.length; ++i) {
            String str = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i >= this.exceptionIndexTable.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        ExceptionTable c = (ExceptionTable)this.clone();
        if (this.exceptionIndexTable != null) {
            c.exceptionIndexTable = new int[this.exceptionIndexTable.length];
            System.arraycopy(this.exceptionIndexTable, 0, c.exceptionIndexTable, 0, this.exceptionIndexTable.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

