/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.util.Stack;
import org.apache.bcel.classfile.AnnotationDefault;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantDynamic;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantModule;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPackage;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.EnclosingMethod;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.MethodParameter;
import org.apache.bcel.classfile.MethodParameters;
import org.apache.bcel.classfile.Module;
import org.apache.bcel.classfile.ModuleExports;
import org.apache.bcel.classfile.ModuleMainClass;
import org.apache.bcel.classfile.ModuleOpens;
import org.apache.bcel.classfile.ModulePackages;
import org.apache.bcel.classfile.ModuleProvides;
import org.apache.bcel.classfile.ModuleRequires;
import org.apache.bcel.classfile.NestHost;
import org.apache.bcel.classfile.NestMembers;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.classfile.Visitor;

public class DescendingVisitor
implements Visitor {
    private final JavaClass clazz;
    private final Visitor visitor;
    private final Stack<Object> stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass clazz, Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    @Override
    public void visitJavaClass(JavaClass _clazz) {
        Attribute[] attributes;
        Method[] methods;
        Field[] fields;
        this.stack.push(_clazz);
        _clazz.accept(this.visitor);
        for (Field field : fields = _clazz.getFields()) {
            field.accept(this);
        }
        for (Method method : methods = _clazz.getMethods()) {
            method.accept(this);
        }
        for (Attribute attribute : attributes = _clazz.getAttributes()) {
            attribute.accept(this);
        }
        _clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    @Override
    public void visitAnnotation(Annotations annotation) {
        AnnotationEntry[] entries;
        this.stack.push(annotation);
        annotation.accept(this.visitor);
        for (AnnotationEntry entrie : entries = annotation.getAnnotationEntries()) {
            entrie.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitAnnotationEntry(AnnotationEntry annotationEntry) {
        this.stack.push(annotationEntry);
        annotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitField(Field field) {
        Attribute[] attributes;
        this.stack.push(field);
        field.accept(this.visitor);
        for (Attribute attribute : attributes = field.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantValue(ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethod(Method method) {
        Attribute[] attributes;
        this.stack.push(method);
        method.accept(this.visitor);
        for (Attribute attribute : attributes = method.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitExceptionTable(ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitCode(Code code) {
        Attribute[] attributes;
        CodeException[] table;
        this.stack.push(code);
        code.accept(this.visitor);
        for (CodeException element : table = code.getExceptionTable()) {
            element.accept(this);
        }
        for (Attribute attribute : attributes = code.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitCodeException(CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLineNumberTable(LineNumberTable table) {
        LineNumber[] numbers;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LineNumber number : numbers = table.getLineNumberTable()) {
            number.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitLineNumber(LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTable(LocalVariableTable table) {
        LocalVariable[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LocalVariable var2 : vars = table.getLocalVariableTable()) {
            var2.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMap(StackMap table) {
        StackMapEntry[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (StackMapEntry var2 : vars = table.getStackMap()) {
            var2.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMapEntry(StackMapEntry var2) {
        this.stack.push(var2);
        var2.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariable(LocalVariable var2) {
        this.stack.push(var2);
        var2.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPool(ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        for (int i = 1; i < constants.length; ++i) {
            if (constants[i] == null) continue;
            constants[i].accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantClass(ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDouble(ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFieldref(ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFloat(ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInteger(ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInvokeDynamic(ConstantInvokeDynamic constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantLong(ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodref(ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantNameAndType(ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantString(ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantUtf8(ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitInnerClasses(InnerClasses ic) {
        InnerClass[] ics;
        this.stack.push(ic);
        ic.accept(this.visitor);
        for (InnerClass ic2 : ics = ic.getInnerClasses()) {
            ic2.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitInnerClass(InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitBootstrapMethods(BootstrapMethods bm) {
        this.stack.push(bm);
        bm.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitDeprecated(Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSignature(Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSourceFile(SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSynthetic(Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitUnknown(Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitAnnotationDefault(AnnotationDefault obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitEnclosingMethod(EnclosingMethod obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTypeTable(LocalVariableTypeTable obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotation(ParameterAnnotations obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethodParameters(MethodParameters obj) {
        MethodParameter[] table;
        this.stack.push(obj);
        obj.accept(this.visitor);
        for (MethodParameter element : table = obj.getParameters()) {
            element.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitMethodParameter(MethodParameter obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodType(ConstantMethodType obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodHandle(ConstantMethodHandle obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotationEntry(ParameterAnnotationEntry obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPackage(ConstantPackage obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantModule(ConstantModule obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDynamic(ConstantDynamic obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModule(Module obj) {
        ModuleProvides[] ptable;
        ModuleOpens[] otable;
        ModuleExports[] etable;
        ModuleRequires[] rtable;
        this.stack.push(obj);
        obj.accept(this.visitor);
        for (ModuleRequires element : rtable = obj.getRequiresTable()) {
            element.accept(this);
        }
        for (ModuleExports element : etable = obj.getExportsTable()) {
            element.accept(this);
        }
        for (ModuleOpens element : otable = obj.getOpensTable()) {
            element.accept(this);
        }
        for (ModuleProvides element : ptable = obj.getProvidesTable()) {
            element.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitModuleRequires(ModuleRequires obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleExports(ModuleExports obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleOpens(ModuleOpens obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleProvides(ModuleProvides obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModulePackages(ModulePackages obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleMainClass(ModuleMainClass obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitNestHost(NestHost obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitNestMembers(NestMembers obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }
}

