/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data.descriptor;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import java.util.Objects;

public class GenericDescriptor
extends Descriptor {
    @JacksonXmlProperty(isAttribute=true, localName="value")
    private final String value;

    public GenericDescriptor(String schemeIdUri, String value, String id) {
        super(schemeIdUri, id);
        this.value = value;
    }

    public GenericDescriptor(String schemeIdUri, String value) {
        this(schemeIdUri, value, null);
    }

    private GenericDescriptor() {
        super(null, null);
        this.value = null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericDescriptor that = (GenericDescriptor)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    public String toString() {
        return "GenericDescriptor{value='" + this.value + "', schemeIdUri='" + this.schemeIdUri + "', id='" + this.id + "'}";
    }

    public Builder buildUpon() {
        return new Builder().withId(this.id).withSchemeIdUri(this.schemeIdUri).withValue(this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String value;
        private String schemeIdUri;
        private String id;

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withSchemeIdUri(String schemeIdUri) {
            this.schemeIdUri = schemeIdUri;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public GenericDescriptor build() {
            return new GenericDescriptor(this.schemeIdUri, this.value, this.id);
        }
    }
}

