/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.lindstrom.mpd.data.URLType;
import java.util.Objects;

public class SegmentBase {
    @JacksonXmlProperty(localName="Initialization", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType initialization;
    @JacksonXmlProperty(localName="RepresentationIndex", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final URLType representationIndex;
    @JacksonXmlProperty(isAttribute=true)
    private final Long timescale;
    @JacksonXmlProperty(isAttribute=true)
    private final Long presentationTimeOffset;
    @JacksonXmlProperty(isAttribute=true)
    private final String indexRange;
    @JacksonXmlProperty(isAttribute=true)
    private final Boolean indexRangeExact;
    @JacksonXmlProperty(isAttribute=true)
    private final Double availabilityTimeOffset;
    @JacksonXmlProperty(isAttribute=true)
    private final Boolean availabilityTimeComplete;

    protected SegmentBase(URLType initialization, URLType representationIndex, Long timescale, Long presentationTimeOffset, String indexRange, Boolean indexRangeExact, Double availabilityTimeOffset, Boolean availabilityTimeComplete) {
        this.initialization = initialization;
        this.representationIndex = representationIndex;
        this.timescale = timescale;
        this.presentationTimeOffset = presentationTimeOffset;
        this.indexRange = indexRange;
        this.indexRangeExact = indexRangeExact;
        this.availabilityTimeOffset = availabilityTimeOffset;
        this.availabilityTimeComplete = availabilityTimeComplete;
    }

    protected SegmentBase() {
        this.initialization = null;
        this.representationIndex = null;
        this.timescale = null;
        this.presentationTimeOffset = null;
        this.indexRange = null;
        this.indexRangeExact = null;
        this.availabilityTimeOffset = null;
        this.availabilityTimeComplete = null;
    }

    public URLType getInitialization() {
        return this.initialization;
    }

    public URLType getRepresentationIndex() {
        return this.representationIndex;
    }

    public Long getTimescale() {
        return this.timescale;
    }

    public Long getPresentationTimeOffset() {
        return this.presentationTimeOffset;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public Boolean getIndexRangeExact() {
        return this.indexRangeExact;
    }

    public Double getAvailabilityTimeOffset() {
        return this.availabilityTimeOffset;
    }

    public Boolean getAvailabilityTimeComplete() {
        return this.availabilityTimeComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentBase that = (SegmentBase)o;
        return Objects.equals(this.initialization, that.initialization) && Objects.equals(this.representationIndex, that.representationIndex) && Objects.equals(this.timescale, that.timescale) && Objects.equals(this.presentationTimeOffset, that.presentationTimeOffset) && Objects.equals(this.indexRange, that.indexRange) && Objects.equals(this.indexRangeExact, that.indexRangeExact) && Objects.equals(this.availabilityTimeOffset, that.availabilityTimeOffset) && Objects.equals(this.availabilityTimeComplete, that.availabilityTimeComplete);
    }

    public int hashCode() {
        return Objects.hash(this.initialization, this.representationIndex, this.timescale, this.presentationTimeOffset, this.indexRange, this.indexRangeExact, this.availabilityTimeOffset, this.availabilityTimeComplete);
    }

    public String toString() {
        return "SegmentBase{initialization=" + this.initialization + ", representationIndex=" + this.representationIndex + ", timescale=" + this.timescale + ", presentationTimeOffset=" + this.presentationTimeOffset + ", indexRange='" + this.indexRange + "', indexRangeExact=" + this.indexRangeExact + ", availabilityTimeOffset=" + this.availabilityTimeOffset + ", availabilityTimeComplete=" + this.availabilityTimeComplete + "}";
    }

    public Builder buildUpon() {
        return this.buildUpon(new Builder());
    }

    <T extends AbstractBuilder<T>> T buildUpon(T builder) {
        return (T)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)builder.withInitialization(this.initialization)).withRepresentationIndex(this.representationIndex)).withTimescale(this.timescale)).withPresentationTimeOffset(this.presentationTimeOffset)).withIndexRange(this.indexRange)).withIndexRangeExact(this.indexRangeExact)).withAvailabilityTimeOffset(this.availabilityTimeOffset)).withAvailabilityTimeComplete(this.availabilityTimeComplete));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public SegmentBase build() {
            return new SegmentBase(this.initialization, this.representationIndex, this.timescale, this.presentationTimeOffset, this.indexRange, this.indexRangeExact, this.availabilityTimeOffset, this.availabilityTimeComplete);
        }

        @Override
        Builder getThis() {
            return this;
        }
    }

    static abstract class AbstractBuilder<T> {
        URLType initialization;
        URLType representationIndex;
        Long timescale;
        Long presentationTimeOffset;
        String indexRange;
        Boolean indexRangeExact;
        Double availabilityTimeOffset;
        Boolean availabilityTimeComplete;

        AbstractBuilder() {
        }

        public T withInitialization(URLType initialization) {
            this.initialization = initialization;
            return this.getThis();
        }

        public T withRepresentationIndex(URLType representationIndex) {
            this.representationIndex = representationIndex;
            return this.getThis();
        }

        public T withTimescale(Long timescale) {
            this.timescale = timescale;
            return this.getThis();
        }

        public T withPresentationTimeOffset(Long presentationTimeOffset) {
            this.presentationTimeOffset = presentationTimeOffset;
            return this.getThis();
        }

        public T withIndexRange(String indexRange) {
            this.indexRange = indexRange;
            return this.getThis();
        }

        public T withIndexRangeExact(Boolean indexRangeExact) {
            this.indexRangeExact = indexRangeExact;
            return this.getThis();
        }

        public T withAvailabilityTimeOffset(Double availabilityTimeOffset) {
            this.availabilityTimeOffset = availabilityTimeOffset;
            return this.getThis();
        }

        public T withAvailabilityTimeComplete(Boolean availabilityTimeComplete) {
            this.availabilityTimeComplete = availabilityTimeComplete;
            return this.getThis();
        }

        abstract T getThis();
    }
}

