/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.lindstrom.mpd.data.EventStream;
import io.lindstrom.mpd.data.FrameRate;
import io.lindstrom.mpd.data.Ratio;
import io.lindstrom.mpd.data.VideoScanType;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import io.lindstrom.mpd.support.Utils;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"framePackings", "audioChannelConfigurations", "contentProtections", "essentialProperties", "supplementalProperties", "inbandEventStreams"})
public abstract class RepresentationBase {
    @JacksonXmlProperty(localName="FramePacking", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> framePackings;
    @JacksonXmlProperty(localName="AudioChannelConfiguration", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> audioChannelConfigurations;
    @JacksonXmlProperty(localName="ContentProtection", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> contentProtections;
    @JacksonXmlProperty(localName="EssentialProperty", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> essentialProperties;
    @JacksonXmlProperty(localName="SupplementalProperty", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> supplementalProperties;
    @JacksonXmlProperty(localName="InbandEventStream", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<EventStream> inbandEventStreams;
    @JacksonXmlProperty(isAttribute=true)
    private final String profiles;
    @JacksonXmlProperty(isAttribute=true)
    private final Long width;
    @JacksonXmlProperty(isAttribute=true)
    private final Long height;
    @JacksonXmlProperty(isAttribute=true)
    private final Ratio sar;
    @JacksonXmlProperty(isAttribute=true)
    private final FrameRate frameRate;
    @JacksonXmlProperty(isAttribute=true)
    private final String audioSamplingRate;
    @JacksonXmlProperty(isAttribute=true)
    private final String mimeType;
    @JacksonXmlProperty(isAttribute=true)
    private final String segmentProfiles;
    @JacksonXmlProperty(isAttribute=true)
    private final String codecs;
    @JacksonXmlProperty(isAttribute=true)
    private final Double maximumSAPPeriod;
    @JacksonXmlProperty(isAttribute=true)
    private final Long startWithSAP;
    @JacksonXmlProperty(isAttribute=true)
    private final Double maxPlayoutRate;
    @JacksonXmlProperty(isAttribute=true)
    private final Boolean codingDependency;
    @JacksonXmlProperty(isAttribute=true)
    private final VideoScanType scanType;

    RepresentationBase(List<Descriptor> framePackings, List<Descriptor> audioChannelConfigurations, List<Descriptor> contentProtections, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties, List<EventStream> inbandEventStreams, String profiles, Long width, Long height, Ratio sar, FrameRate frameRate, String audioSamplingRate, String mimeType, String segmentProfiles, String codecs, Double maximumSAPPeriod, Long startWithSAP, Double maxPlayoutRate, Boolean codingDependency, VideoScanType scanType) {
        this.framePackings = framePackings;
        this.audioChannelConfigurations = audioChannelConfigurations;
        this.contentProtections = contentProtections;
        this.essentialProperties = essentialProperties;
        this.supplementalProperties = supplementalProperties;
        this.inbandEventStreams = inbandEventStreams;
        this.profiles = profiles;
        this.width = width;
        this.height = height;
        this.sar = sar;
        this.frameRate = frameRate;
        this.audioSamplingRate = audioSamplingRate;
        this.mimeType = mimeType;
        this.segmentProfiles = segmentProfiles;
        this.codecs = codecs;
        this.maximumSAPPeriod = maximumSAPPeriod;
        this.startWithSAP = startWithSAP;
        this.maxPlayoutRate = maxPlayoutRate;
        this.codingDependency = codingDependency;
        this.scanType = scanType;
    }

    RepresentationBase() {
        this.framePackings = null;
        this.audioChannelConfigurations = null;
        this.contentProtections = null;
        this.essentialProperties = null;
        this.supplementalProperties = null;
        this.inbandEventStreams = null;
        this.profiles = null;
        this.width = null;
        this.height = null;
        this.sar = null;
        this.frameRate = null;
        this.audioSamplingRate = null;
        this.mimeType = null;
        this.segmentProfiles = null;
        this.codecs = null;
        this.maximumSAPPeriod = null;
        this.startWithSAP = null;
        this.maxPlayoutRate = null;
        this.codingDependency = null;
        this.scanType = null;
    }

    public List<Descriptor> getFramePackings() {
        return Utils.unmodifiableList(this.framePackings);
    }

    public List<Descriptor> getAudioChannelConfigurations() {
        return Utils.unmodifiableList(this.audioChannelConfigurations);
    }

    public List<Descriptor> getContentProtections() {
        return Utils.unmodifiableList(this.contentProtections);
    }

    public List<Descriptor> getEssentialProperties() {
        return Utils.unmodifiableList(this.essentialProperties);
    }

    public List<Descriptor> getSupplementalProperties() {
        return Utils.unmodifiableList(this.supplementalProperties);
    }

    public List<EventStream> getInbandEventStreams() {
        return Utils.unmodifiableList(this.inbandEventStreams);
    }

    public String getProfiles() {
        return this.profiles;
    }

    public Long getWidth() {
        return this.width;
    }

    public Long getHeight() {
        return this.height;
    }

    public Ratio getSar() {
        return this.sar;
    }

    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    public String getAudioSamplingRate() {
        return this.audioSamplingRate;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getSegmentProfiles() {
        return this.segmentProfiles;
    }

    public String getCodecs() {
        return this.codecs;
    }

    public Double getMaximumSAPPeriod() {
        return this.maximumSAPPeriod;
    }

    public Long getStartWithSAP() {
        return this.startWithSAP;
    }

    public Double getMaxPlayoutRate() {
        return this.maxPlayoutRate;
    }

    public Boolean getCodingDependency() {
        return this.codingDependency;
    }

    public VideoScanType getScanType() {
        return this.scanType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepresentationBase)) {
            return false;
        }
        RepresentationBase that = (RepresentationBase)o;
        return Objects.equals(this.framePackings, that.framePackings) && Objects.equals(this.audioChannelConfigurations, that.audioChannelConfigurations) && Objects.equals(this.contentProtections, that.contentProtections) && Objects.equals(this.essentialProperties, that.essentialProperties) && Objects.equals(this.supplementalProperties, that.supplementalProperties) && Objects.equals(this.inbandEventStreams, that.inbandEventStreams) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height) && Objects.equals(this.sar, that.sar) && Objects.equals(this.frameRate, that.frameRate) && Objects.equals(this.audioSamplingRate, that.audioSamplingRate) && Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.segmentProfiles, that.segmentProfiles) && Objects.equals(this.codecs, that.codecs) && Objects.equals(this.maximumSAPPeriod, that.maximumSAPPeriod) && Objects.equals(this.startWithSAP, that.startWithSAP) && Objects.equals(this.maxPlayoutRate, that.maxPlayoutRate) && Objects.equals(this.codingDependency, that.codingDependency) && this.scanType == that.scanType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.framePackings, this.audioChannelConfigurations, this.contentProtections, this.essentialProperties, this.supplementalProperties, this.inbandEventStreams, this.profiles, this.width, this.height, this.sar, this.frameRate, this.audioSamplingRate, this.mimeType, this.segmentProfiles, this.codecs, this.maximumSAPPeriod, this.startWithSAP, this.maxPlayoutRate, this.codingDependency, this.scanType});
    }

    public String toString() {
        return "RepresentationBase{framePackings=" + this.framePackings + ", audioChannelConfigurations=" + this.audioChannelConfigurations + ", contentProtections=" + this.contentProtections + ", essentialProperties=" + this.essentialProperties + ", supplementalProperties=" + this.supplementalProperties + ", inbandEventStreams=" + this.inbandEventStreams + ", profiles='" + this.profiles + "', width=" + this.width + ", height=" + this.height + ", sar='" + this.sar + "', frameRate='" + this.frameRate + "', audioSamplingRate='" + this.audioSamplingRate + "', mimeType='" + this.mimeType + "', segmentProfiles='" + this.segmentProfiles + "', codecs='" + this.codecs + "', maximumSAPPeriod=" + this.maximumSAPPeriod + ", startWithSAP=" + this.startWithSAP + ", maxPlayoutRate=" + this.maxPlayoutRate + ", codingDependency=" + this.codingDependency + ", scanType=" + this.scanType + "}";
    }

    <T extends AbstractBuilder<T>> T buildUpon(T builder) {
        return (T)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)((AbstractBuilder)builder.withFramePackings(this.framePackings)).withAudioChannelConfigurations(this.audioChannelConfigurations)).withContentProtections(this.contentProtections)).withEssentialProperties(this.essentialProperties)).withSupplementalProperties(this.supplementalProperties)).withInbandEventStreams(this.inbandEventStreams)).withProfiles(this.profiles)).withWidth(this.width)).withHeight(this.height)).withSar(this.sar)).withFrameRate(this.frameRate)).withAudioSamplingRate(this.audioSamplingRate)).withMimeType(this.mimeType)).withSegmentProfiles(this.segmentProfiles)).withCodecs(this.codecs)).withMaximumSAPPeriod(this.maximumSAPPeriod)).withStartWithSAP(this.startWithSAP)).withMaxPlayoutRate(this.maxPlayoutRate)).withCodingDependency(this.codingDependency)).withScanType(this.scanType));
    }

    static abstract class AbstractBuilder<T> {
        List<Descriptor> framePackings;
        List<Descriptor> audioChannelConfigurations;
        List<Descriptor> contentProtections;
        List<Descriptor> essentialProperties;
        List<Descriptor> supplementalProperties;
        List<EventStream> inbandEventStreams;
        String profiles;
        Long width;
        Long height;
        Ratio sar;
        FrameRate frameRate;
        String audioSamplingRate;
        String mimeType;
        String segmentProfiles;
        String codecs;
        Double maximumSAPPeriod;
        Long startWithSAP;
        Double maxPlayoutRate;
        Boolean codingDependency;
        VideoScanType scanType;

        AbstractBuilder() {
        }

        abstract T getThis();

        public T withFramePackings(List<Descriptor> framePackings) {
            this.framePackings = framePackings;
            return this.getThis();
        }

        public T withAudioChannelConfigurations(List<Descriptor> audioChannelConfigurations) {
            this.audioChannelConfigurations = audioChannelConfigurations;
            return this.getThis();
        }

        public T withAudioChannelConfigurations(Descriptor audioChannelConfiguration, Descriptor ... moreAudioChannelConfigurations) {
            this.audioChannelConfigurations = Utils.varargsToList(audioChannelConfiguration, moreAudioChannelConfigurations);
            return this.getThis();
        }

        public T withContentProtections(List<Descriptor> contentProtections) {
            this.contentProtections = contentProtections;
            return this.getThis();
        }

        public T withEssentialProperties(List<Descriptor> essentialProperties) {
            this.essentialProperties = essentialProperties;
            return this.getThis();
        }

        public T withSupplementalProperties(List<Descriptor> supplementalProperties) {
            this.supplementalProperties = supplementalProperties;
            return this.getThis();
        }

        public T withInbandEventStreams(List<EventStream> inbandEventStreams) {
            this.inbandEventStreams = inbandEventStreams;
            return this.getThis();
        }

        public T withProfiles(String profiles) {
            this.profiles = profiles;
            return this.getThis();
        }

        public T withWidth(Long width) {
            this.width = width;
            return this.getThis();
        }

        public T withWidth(int width) {
            this.width = width;
            return this.getThis();
        }

        public T withHeight(Long height) {
            this.height = height;
            return this.getThis();
        }

        public T withHeight(int height) {
            this.height = height;
            return this.getThis();
        }

        public T withSar(Ratio sar) {
            this.sar = sar;
            return this.getThis();
        }

        public T withFrameRate(FrameRate frameRate) {
            this.frameRate = frameRate;
            return this.getThis();
        }

        public T withAudioSamplingRate(String audioSamplingRate) {
            this.audioSamplingRate = audioSamplingRate;
            return this.getThis();
        }

        public T withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this.getThis();
        }

        public T withSegmentProfiles(String segmentProfiles) {
            this.segmentProfiles = segmentProfiles;
            return this.getThis();
        }

        public T withCodecs(String codecs) {
            this.codecs = codecs;
            return this.getThis();
        }

        public T withMaximumSAPPeriod(Double maximumSAPPeriod) {
            this.maximumSAPPeriod = maximumSAPPeriod;
            return this.getThis();
        }

        public T withStartWithSAP(Long startWithSAP) {
            this.startWithSAP = startWithSAP;
            return this.getThis();
        }

        public T withMaxPlayoutRate(Double maxPlayoutRate) {
            this.maxPlayoutRate = maxPlayoutRate;
            return this.getThis();
        }

        public T withCodingDependency(Boolean codingDependency) {
            this.codingDependency = codingDependency;
            return this.getThis();
        }

        public T withScanType(VideoScanType scanType) {
            this.scanType = scanType;
            return this.getThis();
        }
    }
}

