/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.lindstrom.mpd.data.BaseURL;
import io.lindstrom.mpd.data.Metrics;
import io.lindstrom.mpd.data.Period;
import io.lindstrom.mpd.data.PresentationType;
import io.lindstrom.mpd.data.Profile;
import io.lindstrom.mpd.data.Profiles;
import io.lindstrom.mpd.data.ProgramInformation;
import io.lindstrom.mpd.data.UTCTiming;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import io.lindstrom.mpd.support.Utils;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"programInformations", "baseURLs", "locations", "periods", "metrics", "essentialProperties", "supplementalProperties", "utcTimings"})
@JacksonXmlRootElement(localName="MPD", namespace="urn:mpeg:dash:schema:mpd:2011")
public class MPD {
    static final String NAMESPACE = "urn:mpeg:dash:schema:mpd:2011";
    @JacksonXmlProperty(localName="ProgramInformation", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<ProgramInformation> programInformations;
    @JacksonXmlProperty(localName="BaseURL", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<BaseURL> baseURLs;
    @JacksonXmlProperty(localName="Location", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<String> locations;
    @JacksonXmlProperty(localName="Period", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Period> periods;
    @JacksonXmlProperty(localName="Metrics", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Metrics> metrics;
    @JacksonXmlProperty(localName="EssentialProperty", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> essentialProperties;
    @JacksonXmlProperty(localName="SupplementalProperty", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> supplementalProperties;
    @JacksonXmlProperty(localName="UTCTiming", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<UTCTiming> utcTimings;
    @JacksonXmlProperty(isAttribute=true, namespace="http://www.w3.org/2001/XMLSchema-instance")
    private final String schemaLocation;
    @JacksonXmlProperty(isAttribute=true)
    private final String id;
    @JacksonXmlProperty(isAttribute=true)
    private final Profiles profiles;
    @JacksonXmlProperty(isAttribute=true)
    private final PresentationType type;
    @JacksonXmlProperty(isAttribute=true)
    private final OffsetDateTime availabilityStartTime;
    @JacksonXmlProperty(isAttribute=true)
    private final OffsetDateTime availabilityEndTime;
    @JacksonXmlProperty(isAttribute=true)
    private final OffsetDateTime publishTime;
    @JacksonXmlProperty(isAttribute=true)
    private final Duration mediaPresentationDuration;
    @JacksonXmlProperty(isAttribute=true)
    private final Duration minimumUpdatePeriod;
    @JacksonXmlProperty(isAttribute=true)
    private final Duration minBufferTime;
    @JacksonXmlProperty(isAttribute=true)
    private final Duration timeShiftBufferDepth;
    @JacksonXmlProperty(isAttribute=true)
    private final Duration suggestedPresentationDelay;
    @JacksonXmlProperty(isAttribute=true)
    private final Duration maxSegmentDuration;
    @JacksonXmlProperty(isAttribute=true)
    private final Duration maxSubsegmentDuration;

    private MPD(String schemaLocation, List<ProgramInformation> programInformations, List<BaseURL> baseURLs, List<String> locations, List<Period> periods, List<Metrics> metrics, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties, List<UTCTiming> utcTimings, String id, Profiles profiles, PresentationType type, OffsetDateTime availabilityStartTime, OffsetDateTime availabilityEndTime, OffsetDateTime publishTime, Duration mediaPresentationDuration, Duration minimumUpdatePeriod, Duration minBufferTime, Duration timeShiftBufferDepth, Duration suggestedPresentationDelay, Duration maxSegmentDuration, Duration maxSubsegmentDuration) {
        this.schemaLocation = schemaLocation;
        this.programInformations = programInformations;
        this.baseURLs = baseURLs;
        this.locations = locations;
        this.periods = periods;
        this.metrics = metrics;
        this.essentialProperties = essentialProperties;
        this.supplementalProperties = supplementalProperties;
        this.utcTimings = utcTimings;
        this.id = id;
        this.profiles = profiles;
        this.type = type;
        this.availabilityStartTime = availabilityStartTime;
        this.availabilityEndTime = availabilityEndTime;
        this.publishTime = publishTime;
        this.mediaPresentationDuration = mediaPresentationDuration;
        this.minimumUpdatePeriod = minimumUpdatePeriod;
        this.minBufferTime = minBufferTime;
        this.timeShiftBufferDepth = timeShiftBufferDepth;
        this.suggestedPresentationDelay = suggestedPresentationDelay;
        this.maxSegmentDuration = maxSegmentDuration;
        this.maxSubsegmentDuration = maxSubsegmentDuration;
    }

    private MPD() {
        this.programInformations = null;
        this.baseURLs = null;
        this.locations = null;
        this.periods = null;
        this.metrics = null;
        this.essentialProperties = null;
        this.supplementalProperties = null;
        this.utcTimings = null;
        this.id = null;
        this.profiles = null;
        this.type = null;
        this.availabilityStartTime = null;
        this.availabilityEndTime = null;
        this.publishTime = null;
        this.mediaPresentationDuration = null;
        this.minimumUpdatePeriod = null;
        this.minBufferTime = null;
        this.timeShiftBufferDepth = null;
        this.suggestedPresentationDelay = null;
        this.maxSegmentDuration = null;
        this.maxSubsegmentDuration = null;
        this.schemaLocation = null;
    }

    public List<ProgramInformation> getProgramInformations() {
        return Utils.unmodifiableList(this.programInformations);
    }

    public List<BaseURL> getBaseURLs() {
        return Utils.unmodifiableList(this.baseURLs);
    }

    public List<String> getLocations() {
        return Utils.unmodifiableList(this.locations);
    }

    public List<Period> getPeriods() {
        return Utils.unmodifiableList(this.periods);
    }

    public List<Metrics> getMetrics() {
        return Utils.unmodifiableList(this.metrics);
    }

    public List<Descriptor> getEssentialProperties() {
        return Utils.unmodifiableList(this.essentialProperties);
    }

    public List<Descriptor> getSupplementalProperties() {
        return Utils.unmodifiableList(this.supplementalProperties);
    }

    public List<UTCTiming> getUtcTimings() {
        return Utils.unmodifiableList(this.utcTimings);
    }

    public String getId() {
        return this.id;
    }

    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            return List.of();
        }
        return this.profiles.getProfiles();
    }

    public List<String> getInteroperabilityPointsAndExtensions() {
        if (this.profiles == null) {
            return List.of();
        }
        return this.profiles.getInteroperabilityPointsAndExtensions();
    }

    public PresentationType getType() {
        return this.type;
    }

    public OffsetDateTime getAvailabilityStartTime() {
        return this.availabilityStartTime;
    }

    public OffsetDateTime getAvailabilityEndTime() {
        return this.availabilityEndTime;
    }

    public OffsetDateTime getPublishTime() {
        return this.publishTime;
    }

    public Duration getMediaPresentationDuration() {
        return this.mediaPresentationDuration;
    }

    public Duration getMinimumUpdatePeriod() {
        return this.minimumUpdatePeriod;
    }

    public Duration getMinBufferTime() {
        return this.minBufferTime;
    }

    public Duration getTimeShiftBufferDepth() {
        return this.timeShiftBufferDepth;
    }

    public Duration getSuggestedPresentationDelay() {
        return this.suggestedPresentationDelay;
    }

    public Duration getMaxSegmentDuration() {
        return this.maxSegmentDuration;
    }

    public Duration getMaxSubsegmentDuration() {
        return this.maxSubsegmentDuration;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MPD mpd = (MPD)o;
        return Objects.equals(this.programInformations, mpd.programInformations) && Objects.equals(this.baseURLs, mpd.baseURLs) && Objects.equals(this.locations, mpd.locations) && Objects.equals(this.periods, mpd.periods) && Objects.equals(this.metrics, mpd.metrics) && Objects.equals(this.essentialProperties, mpd.essentialProperties) && Objects.equals(this.supplementalProperties, mpd.supplementalProperties) && Objects.equals(this.utcTimings, mpd.utcTimings) && Objects.equals(this.id, mpd.id) && Objects.equals(this.profiles, mpd.profiles) && this.type == mpd.type && Objects.equals(this.availabilityStartTime, mpd.availabilityStartTime) && Objects.equals(this.availabilityEndTime, mpd.availabilityEndTime) && Objects.equals(this.publishTime, mpd.publishTime) && Objects.equals(this.mediaPresentationDuration, mpd.mediaPresentationDuration) && Objects.equals(this.minimumUpdatePeriod, mpd.minimumUpdatePeriod) && Objects.equals(this.minBufferTime, mpd.minBufferTime) && Objects.equals(this.timeShiftBufferDepth, mpd.timeShiftBufferDepth) && Objects.equals(this.suggestedPresentationDelay, mpd.suggestedPresentationDelay) && Objects.equals(this.maxSegmentDuration, mpd.maxSegmentDuration) && Objects.equals(this.maxSubsegmentDuration, mpd.maxSubsegmentDuration) && Objects.equals(this.schemaLocation, mpd.schemaLocation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.programInformations, this.baseURLs, this.locations, this.periods, this.metrics, this.essentialProperties, this.supplementalProperties, this.utcTimings, this.id, this.profiles, this.type, this.availabilityStartTime, this.availabilityEndTime, this.publishTime, this.mediaPresentationDuration, this.minimumUpdatePeriod, this.minBufferTime, this.timeShiftBufferDepth, this.suggestedPresentationDelay, this.maxSegmentDuration, this.maxSubsegmentDuration, this.schemaLocation});
    }

    public String toString() {
        return "MPD{programInformations=" + this.programInformations + ", baseURLs=" + this.baseURLs + ", locations=" + this.locations + ", periods=" + this.periods + ", metrics=" + this.metrics + ", essentialProperties=" + this.essentialProperties + ", supplementalProperties=" + this.supplementalProperties + ", utcTimings=" + this.utcTimings + ", id='" + this.id + "', profiles='" + this.profiles + "', type=" + this.type + ", availabilityStartTime=" + this.availabilityStartTime + ", availabilityEndTime=" + this.availabilityEndTime + ", publishTime=" + this.publishTime + ", mediaPresentationDuration=" + this.mediaPresentationDuration + ", minimumUpdatePeriod=" + this.minimumUpdatePeriod + ", minBufferTime=" + this.minBufferTime + ", timeShiftBufferDepth=" + this.timeShiftBufferDepth + ", suggestedPresentationDelay=" + this.suggestedPresentationDelay + ", maxSegmentDuration=" + this.maxSegmentDuration + ", maxSubsegmentDuration=" + this.maxSubsegmentDuration + ", schemaLocation='" + this.schemaLocation + "'}";
    }

    public Builder buildUpon() {
        return new Builder().withProgramInformations(this.programInformations).withBaseURLs(this.baseURLs).withLocations(this.locations).withPeriods(this.periods).withMetrics(this.metrics).withEssentialProperties(this.essentialProperties).withSupplementalProperties(this.supplementalProperties).withUtcTimings(this.utcTimings).withId(this.id).withProfiles(this.profiles).withType(this.type).withAvailabilityStartTime(this.availabilityStartTime).withAvailabilityEndTime(this.availabilityEndTime).withPublishTime(this.publishTime).withMediaPresentationDuration(this.mediaPresentationDuration).withMinimumUpdatePeriod(this.minimumUpdatePeriod).withMinBufferTime(this.minBufferTime).withTimeShiftBufferDepth(this.timeShiftBufferDepth).withSuggestedPresentationDelay(this.suggestedPresentationDelay).withMaxSegmentDuration(this.maxSegmentDuration).withMaxSubsegmentDuration(this.maxSubsegmentDuration).withSchemaLocation(this.schemaLocation);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_SCHEMA_LOCATION = "urn:mpeg:dash:schema:mpd:2011 http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-DASH_schema_files/DASH-MPD.xsd";
        private List<ProgramInformation> programInformations;
        private List<BaseURL> baseURLs;
        private List<String> locations;
        private List<Period> periods;
        private List<Metrics> metrics;
        private List<Descriptor> essentialProperties;
        private List<Descriptor> supplementalProperties;
        private List<UTCTiming> utcTimings;
        private String id;
        private Profiles profiles;
        private PresentationType type = PresentationType.STATIC;
        private OffsetDateTime availabilityStartTime;
        private OffsetDateTime availabilityEndTime;
        private OffsetDateTime publishTime;
        private Duration mediaPresentationDuration;
        private Duration minimumUpdatePeriod;
        private Duration minBufferTime = Duration.ZERO;
        private Duration timeShiftBufferDepth;
        private Duration suggestedPresentationDelay;
        private Duration maxSegmentDuration;
        private Duration maxSubsegmentDuration;
        private String schemaLocation = "urn:mpeg:dash:schema:mpd:2011 http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-DASH_schema_files/DASH-MPD.xsd";

        public Builder withProgramInformations(List<ProgramInformation> programInformations) {
            this.programInformations = programInformations;
            return this;
        }

        public Builder withBaseURLs(List<BaseURL> baseURLs) {
            this.baseURLs = baseURLs;
            return this;
        }

        public Builder withLocations(List<String> locations) {
            this.locations = locations;
            return this;
        }

        public Builder withPeriods(List<Period> periods) {
            this.periods = periods;
            return this;
        }

        public Builder withPeriods(Period period, Period ... morePeriods) {
            this.periods = Utils.varargsToList(period, morePeriods);
            return this;
        }

        public Builder withMetrics(List<Metrics> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withEssentialProperties(List<Descriptor> essentialProperties) {
            this.essentialProperties = essentialProperties;
            return this;
        }

        public Builder withSupplementalProperties(List<Descriptor> supplementalProperties) {
            this.supplementalProperties = supplementalProperties;
            return this;
        }

        public Builder withUtcTimings(List<UTCTiming> utcTimings) {
            this.utcTimings = utcTimings;
            return this;
        }

        public Builder withUtcTimings(UTCTiming utcTiming, UTCTiming ... moreUtcTiming) {
            this.utcTimings = Utils.varargsToList(utcTiming, moreUtcTiming);
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withProfiles(Profiles profiles) {
            this.profiles = profiles;
            return this;
        }

        public Builder withProfiles(Profile profile2, Profile ... moreProfiles) {
            if (this.profiles == null) {
                this.profiles = new Profiles();
            }
            this.profiles = this.profiles.buildUpon().withProfiles(Utils.varargsToList(profile2, moreProfiles)).build();
            return this;
        }

        public Builder withInteroperabilityPointsAndExtensions(String value, String ... moreValues) {
            if (this.profiles == null) {
                this.profiles = new Profiles();
            }
            this.profiles = this.profiles.buildUpon().withInteroperabilityPointsAndExtensions(Utils.varargsToList(value, moreValues)).build();
            return this;
        }

        public Builder withType(PresentationType type) {
            this.type = type;
            return this;
        }

        public Builder withAvailabilityStartTime(OffsetDateTime availabilityStartTime) {
            this.availabilityStartTime = availabilityStartTime;
            return this;
        }

        public Builder withAvailabilityEndTime(OffsetDateTime availabilityEndTime) {
            this.availabilityEndTime = availabilityEndTime;
            return this;
        }

        public Builder withPublishTime(OffsetDateTime publishTime) {
            this.publishTime = publishTime;
            return this;
        }

        public Builder withMediaPresentationDuration(Duration mediaPresentationDuration) {
            this.mediaPresentationDuration = mediaPresentationDuration;
            return this;
        }

        public Builder withMinimumUpdatePeriod(Duration minimumUpdatePeriod) {
            this.minimumUpdatePeriod = minimumUpdatePeriod;
            return this;
        }

        public Builder withMinBufferTime(Duration minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public Builder withTimeShiftBufferDepth(Duration timeShiftBufferDepth) {
            this.timeShiftBufferDepth = timeShiftBufferDepth;
            return this;
        }

        public Builder withSuggestedPresentationDelay(Duration suggestedPresentationDelay) {
            this.suggestedPresentationDelay = suggestedPresentationDelay;
            return this;
        }

        public Builder withMaxSegmentDuration(Duration maxSegmentDuration) {
            this.maxSegmentDuration = maxSegmentDuration;
            return this;
        }

        public Builder withMaxSubsegmentDuration(Duration maxSubsegmentDuration) {
            this.maxSubsegmentDuration = maxSubsegmentDuration;
            return this;
        }

        public Builder withSchemaLocation(String schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this;
        }

        public MPD build() {
            return new MPD(this.schemaLocation, this.programInformations, this.baseURLs, this.locations, this.periods, this.metrics, this.essentialProperties, this.supplementalProperties, this.utcTimings, this.id, this.profiles, this.type, this.availabilityStartTime, this.availabilityEndTime, this.publishTime, this.mediaPresentationDuration, this.minimumUpdatePeriod, this.minBufferTime, this.timeShiftBufferDepth, this.suggestedPresentationDelay, this.maxSegmentDuration, this.maxSubsegmentDuration);
        }
    }
}

