/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomTruststoreAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomTruststoreAppender.class);

    private CustomTruststoreAppender() {
    }

    public static void appendCustomTrustoreToDefault(String trustorePath, String trustorePassword) throws TrustStoreConfigurationException {
        try {
            X509TrustManager defaultX509TrustManager = CustomTruststoreAppender.getDefaultX509TrustManager();
            X509TrustManager customX509TrustManager = CustomTruststoreAppender.getCustomX509TrustManager(trustorePath, trustorePassword);
            CustomX509TrustManager mergedX509TrustManager = new CustomX509TrustManager(defaultX509TrustManager, customX509TrustManager);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{mergedX509TrustManager}, null);
            SSLContext.setDefault(sslContext);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new TrustStoreConfigurationException(e);
        }
    }

    private static X509TrustManager getDefaultX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager defaultX509TrustManager = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            defaultX509TrustManager = (X509TrustManager)trustManager;
            break;
        }
        return defaultX509TrustManager;
    }

    private static X509TrustManager getCustomX509TrustManager(String truststorePath, String truststorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore customTrustStore;
        try (InputStream truststoreInputStream = Files.newInputStream(Paths.get(truststorePath, new String[0]), new OpenOption[0]);){
            customTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            customTrustStore.load(truststoreInputStream, truststorePassword.toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(customTrustStore);
        X509TrustManager customX509TrustManager = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            customX509TrustManager = (X509TrustManager)trustManager;
            break;
        }
        return customX509TrustManager;
    }

    public static class TrustStoreConfigurationException
    extends Exception {
        private static final long serialVersionUID = -6498227689619898437L;

        TrustStoreConfigurationException(Exception e) {
            super(e);
        }
    }

    private static class CustomX509TrustManager
    implements X509TrustManager {
        private final X509TrustManager x509TrustManager;
        private final X509TrustManager x509TrustManagerToBeMerged;

        CustomX509TrustManager(X509TrustManager x509TrustManager, X509TrustManager x509TrustManagerToBeMerged) {
            this.x509TrustManager = x509TrustManager;
            this.x509TrustManagerToBeMerged = x509TrustManagerToBeMerged;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.x509TrustManager.getAcceptedIssuers();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.x509TrustManagerToBeMerged.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                LOGGER.debug("No custom trusted certificate found", e);
                LOGGER.warn("Custom x509TrustManager did not have trusted certificates for the accessible resource, will try default x509TrustManager now");
                this.x509TrustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.x509TrustManager.checkClientTrusted(chain, authType);
        }
    }
}

