/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.schema.model;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum MediaType {
    AUDIO("AUDIO"),
    VIDEO("VIDEO"),
    TEXT("TEXT"),
    IMAGE("IMAGE"),
    THREE_D("3D"),
    OTHER("OTHER");

    private static final String[] SUPPORTED_APPLICATION_TYPES_AS_TEXT;
    private final String stringRepresentation;

    private MediaType(String stringRepresentation) {
        this.stringRepresentation = stringRepresentation;
    }

    @JsonValue
    public String toString() {
        return this.stringRepresentation;
    }

    public static MediaType getMediaType(String mimeType) {
        MediaType result = mimeType == null ? OTHER : (mimeType.startsWith("image/") ? IMAGE : (mimeType.startsWith("audio/") ? AUDIO : (mimeType.startsWith("video/") || mimeType.startsWith("application/dash+xml") ? VIDEO : (mimeType.startsWith("text/") || MediaType.isApplicationMediaRepresentingText(mimeType) ? TEXT : OTHER))));
        return result;
    }

    private static boolean mediaTypeMatchesCandidate(String candidateType, String mediaType) {
        return mediaType.equals(candidateType) || !candidateType.contains("+") && mediaType.startsWith(candidateType + "+");
    }

    private static boolean isApplicationMediaRepresentingText(String mediaType) {
        String baseType = mediaType.split(";", 2)[0];
        return Arrays.stream(SUPPORTED_APPLICATION_TYPES_AS_TEXT).anyMatch(candidate -> MediaType.mediaTypeMatchesCandidate(candidate, baseType));
    }

    static {
        SUPPORTED_APPLICATION_TYPES_AS_TEXT = new String[]{"application/xml", "application/rtf", "application/epub", "application/pdf", "application/xhtml+xml"};
    }
}

