/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.schema.convert;

import eu.europeana.metis.schema.convert.SerializationException;
import eu.europeana.metis.schema.jibx.RDF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public final class RdfConversionUtils {
    private static final int INDENTATION_SPACE = 2;
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private static IBindingFactory rdfBindingFactory;
    private static Map<String, RdfXmlElementMetadata> rdfXmlElementMetadataMap;
    private static final Pattern complexTypePattern;

    private RdfConversionUtils() {
    }

    public static byte[] convertRdfToBytes(RDF rdf) throws SerializationException {
        try {
            IMarshallingContext context = rdfBindingFactory.createMarshallingContext();
            context.setIndent(2);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            context.marshalDocument((Object)rdf, UTF8, null, out);
            return out.toByteArray();
        }
        catch (JiBXException e) {
            throw new SerializationException("Something went wrong with converting to or from the RDF format.", e);
        }
    }

    public static String getQualifiedElementNameForClass(Class<?> objectClass) {
        RdfXmlElementMetadata rdfXmlElementMetadata = rdfXmlElementMetadataMap.get(objectClass.getCanonicalName());
        Objects.requireNonNull(rdfXmlElementMetadata, String.format("Element metadata not found for class: %s", objectClass.getCanonicalName()));
        return String.format("%s:%s", rdfXmlElementMetadata.getPrefix(), rdfXmlElementMetadata.getName());
    }

    public static RDF convertInputStreamToRdf(InputStream inputStream) throws SerializationException {
        try {
            IUnmarshallingContext context = rdfBindingFactory.createUnmarshallingContext();
            return (RDF)context.unmarshalDocument(inputStream, UTF8);
        }
        catch (JiBXException e) {
            throw new SerializationException("Something went wrong with converting to or from the RDF format.", e);
        }
    }

    private static Map<String, RdfXmlElementMetadata> initializeRdfXmlElementMetadataMap() {
        HashMap<String, RdfXmlElementMetadata> rdfXmlElementMetadataMap = new HashMap<String, RdfXmlElementMetadata>();
        for (int i = 0; i < rdfBindingFactory.getMappedClasses().length; ++i) {
            String canonicalName;
            String elementName;
            String elementNamespace;
            Matcher matcher = complexTypePattern.matcher(rdfBindingFactory.getMappedClasses()[i]);
            if (matcher.matches()) {
                elementNamespace = matcher.group(1);
                elementName = matcher.group(2);
                Pattern canonicalClassNamePattern = Pattern.compile(String.format("^(.*)\\.(%s)$", elementName));
                canonicalName = Arrays.stream(rdfBindingFactory.getAbstractMappings()).flatMap(Arrays::stream).filter(Objects::nonNull).filter(input -> canonicalClassNamePattern.matcher((CharSequence)input).matches()).findFirst().orElse(null);
            } else {
                elementNamespace = rdfBindingFactory.getElementNamespaces()[i];
                elementName = rdfBindingFactory.getElementNames()[i];
                canonicalName = rdfBindingFactory.getMappedClasses()[i];
            }
            RdfConversionUtils.checkAndStoreMetadataInMap(rdfXmlElementMetadataMap, canonicalName, elementNamespace, elementName);
        }
        return rdfXmlElementMetadataMap;
    }

    public static String convertRdfToString(RDF rdf) throws SerializationException {
        try {
            return new String(RdfConversionUtils.convertRdfToBytes(rdf), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected exception - should not occur.", e);
        }
    }

    private static void checkAndStoreMetadataInMap(Map<String, RdfXmlElementMetadata> rdfXmlElementMetadataMap, String canonicalName, String elementNamespace, String elementName) {
        if (canonicalName != null) {
            int namespaceIndex = IntStream.range(0, rdfBindingFactory.getNamespaces().length).filter(j -> rdfBindingFactory.getNamespaces()[j].equals(elementNamespace)).findFirst().orElseThrow();
            String prefix = rdfBindingFactory.getPrefixes()[namespaceIndex];
            RdfXmlElementMetadata rdfXmlElementMetadata = new RdfXmlElementMetadata(canonicalName, prefix, elementNamespace, elementName);
            rdfXmlElementMetadataMap.put(rdfXmlElementMetadata.getCanonicalClassName(), rdfXmlElementMetadata);
        }
    }

    public static RDF convertStringToRdf(String xml) throws SerializationException {
        RDF rDF;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            rDF = RdfConversionUtils.convertInputStreamToRdf(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializationException("Unexpected issue with byte stream.", e);
            }
        }
        ((InputStream)inputStream).close();
        return rDF;
    }

    static void initializeStaticComponents() {
        try {
            rdfBindingFactory = BindingDirectory.getFactory(RDF.class);
            rdfXmlElementMetadataMap = RdfConversionUtils.initializeRdfXmlElementMetadataMap();
        }
        catch (JiBXException e) {
            throw new IllegalStateException("No binding factory available.", e);
        }
    }

    static {
        complexTypePattern = Pattern.compile("^\\{(.*)}:(.*)$");
        RdfConversionUtils.initializeStaticComponents();
    }

    static class RdfXmlElementMetadata {
        final String canonicalClassName;
        final String prefix;
        final String namespace;
        final String name;

        public RdfXmlElementMetadata(String canonicalClassName, String prefix, String namespace, String name) {
            this.canonicalClassName = canonicalClassName;
            this.prefix = prefix;
            this.namespace = namespace;
            this.name = name;
        }

        public String getCanonicalClassName() {
            return this.canonicalClassName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }
    }
}

