/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.network;

import eu.europeana.metis.network.AbstractHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class StringHttpClient
extends AbstractHttpClient<URI, StringContent> {
    public StringHttpClient(int maxRedirectCount, int connectTimeout, int responseTimeout, int requestTimeout) {
        super(maxRedirectCount, connectTimeout, responseTimeout, requestTimeout);
    }

    @Override
    protected String getResourceUrl(URI resourceEntry) {
        return resourceEntry.toString();
    }

    @Override
    protected StringContent createResult(URI providedLink, URI actualUri, String mimeType, Long fileSize, AbstractHttpClient.ContentRetriever contentRetriever) throws IOException {
        try (InputStream inputStream = contentRetriever.getContent();){
            StringContent stringContent = new StringContent(IOUtils.toString(inputStream, StandardCharsets.UTF_8), mimeType);
            return stringContent;
        }
    }

    public static class StringContent {
        private final String content;
        private final String contentType;

        public StringContent(String content, String contentType) {
            this.content = content;
            this.contentType = contentType;
        }

        public String getContent() {
            return this.content;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

