/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.network;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpServerErrorException;

public final class ExternalRequestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRequestUtil.class);
    private static final int MAX_RETRIES = 30;
    private static final int SLEEP_TIMEOUT = 1000;
    public static final Map<Class<?>, String> UNMODIFIABLE_MAP_WITH_NETWORK_EXCEPTIONS;

    private ExternalRequestUtil() {
    }

    public static <R, E extends Exception> R retryableExternalRequest(SupplierThrowingException<R, E> supplierThrowingException) throws E {
        return ExternalRequestUtil.retryableExternalRequest(supplierThrowingException, null, -1, -1);
    }

    public static <R, E extends Exception> R retryableExternalRequest(SupplierThrowingException<R, E> supplierThrowingException, Map<Class<?>, String> exceptionStringMap) throws E {
        return ExternalRequestUtil.retryableExternalRequest(supplierThrowingException, exceptionStringMap, -1, -1);
    }

    public static <R, E extends Exception> R retryableExternalRequest(SupplierThrowingException<R, E> supplierThrowingException, Map<Class<?>, String> exceptionStringMap, int maxRetries, int periodBetweenRetriesInMillis) throws E {
        maxRetries = maxRetries < 0 ? 30 : maxRetries;
        periodBetweenRetriesInMillis = periodBetweenRetriesInMillis < 0 ? 1000 : periodBetweenRetriesInMillis;
        AtomicInteger retriesCounter = new AtomicInteger(0);
        while (true) {
            try {
                return supplierThrowingException.get();
            }
            catch (RuntimeException e) {
                ExternalRequestUtil.doWhenExceptionCaught(e, exceptionStringMap, retriesCounter, maxRetries, periodBetweenRetriesInMillis);
                continue;
            }
            catch (Exception e) {
                Exception castException = e;
                ExternalRequestUtil.doWhenExceptionCaught(castException, exceptionStringMap, retriesCounter, maxRetries, periodBetweenRetriesInMillis);
                continue;
            }
            break;
        }
    }

    public static <R> R retryableExternalRequestForNetworkExceptions(Supplier<R> supplier) {
        return (R)ExternalRequestUtil.retryableExternalRequestForRuntimeExceptions(supplier::get, UNMODIFIABLE_MAP_WITH_NETWORK_EXCEPTIONS, -1, -1);
    }

    public static <R, E extends Exception> R retryableExternalRequestForNetworkExceptionsThrowing(SupplierThrowingException<R, E> supplier) throws E {
        return ExternalRequestUtil.retryableExternalRequestForRuntimeExceptions(supplier, UNMODIFIABLE_MAP_WITH_NETWORK_EXCEPTIONS, -1, -1);
    }

    public static <R, E extends Exception> R retryableExternalRequestForRuntimeExceptions(SupplierThrowingException<R, E> supplier, Map<Class<?>, String> runtimeExceptionStringMap, int maxRetries, int periodBetweenRetriesInMillis) throws E {
        return ExternalRequestUtil.retryableExternalRequest(supplier, runtimeExceptionStringMap, maxRetries, periodBetweenRetriesInMillis);
    }

    private static <E extends Exception> void doWhenExceptionCaught(E e, Map<Class<?>, String> exceptionStringMap, AtomicInteger retriesCounter, int maxRetries, int periodBetweenRetriesInMillis) throws E {
        retriesCounter.incrementAndGet();
        if (!ExternalRequestUtil.isNullOrEmpty(exceptionStringMap)) {
            boolean causeMatches = ExternalRequestUtil.doesExceptionCauseMatchAnyOfProvidedExceptions(exceptionStringMap, e);
            if (retriesCounter.get() > maxRetries || !causeMatches) {
                throw e;
            }
        } else if (retriesCounter.get() > maxRetries) {
            throw e;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(String.format("External request has failed! Retrying in %sms", periodBetweenRetriesInMillis), e);
        }
        try {
            Thread.sleep(periodBetweenRetriesInMillis);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Thread was interrupted while waiting for retry.", ex);
            Thread.currentThread().interrupt();
        }
    }

    public static Map<Class<?>, String> getSocketExceptionConnectionReset() {
        return Collections.singletonMap(SocketException.class, "Connection reset");
    }

    public static boolean doesExceptionCauseMatchAnyOfProvidedExceptions(Map<Class<?>, String> exceptionStringMap, Exception e) {
        Throwable cause = ExternalRequestUtil.getRootCause(e);
        Predicate<Map.Entry> sameInstanceAndMessageMatches = entry -> ((Class)entry.getKey()).isInstance(cause) && (StringUtils.isBlank((CharSequence)entry.getValue()) || cause.getMessage().toLowerCase(Locale.US).contains(((String)entry.getValue()).toLowerCase(Locale.US)));
        boolean foundMatch = false;
        if (!ExternalRequestUtil.isNullOrEmpty(exceptionStringMap)) {
            foundMatch = exceptionStringMap.entrySet().stream().anyMatch(sameInstanceAndMessageMatches);
        }
        return foundMatch;
    }

    public static boolean isNullOrEmpty(Map<?, ?> m3) {
        return m3 == null || m3.isEmpty();
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable cause;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    static {
        ConcurrentHashMap<Class, String> retryableExceptionMap = new ConcurrentHashMap<Class, String>();
        retryableExceptionMap.put(HttpServerErrorException.class, "");
        retryableExceptionMap.put(UnknownHostException.class, "");
        retryableExceptionMap.put(SocketTimeoutException.class, "");
        retryableExceptionMap.put(SocketException.class, "");
        retryableExceptionMap.put(ServiceUnavailableException.class, "");
        retryableExceptionMap.put(NotFoundException.class, "");
        UNMODIFIABLE_MAP_WITH_NETWORK_EXCEPTIONS = Collections.unmodifiableMap(retryableExceptionMap);
    }

    @FunctionalInterface
    public static interface SupplierThrowingException<T, E extends Exception> {
        public T get() throws E;
    }
}

