/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.model.AbstractTemporaryFile;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ResourceImpl
extends AbstractTemporaryFile
implements Resource {
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final Long DEFAULT_FILE_SIZE = 0L;
    private final String providedMimeType;
    private final Long providedFileSize;
    private final Set<UrlType> urlTypes;
    private final URI actualLocation;

    public ResourceImpl(RdfResourceEntry rdfResourceEntry, String providedMimeType, Long providedFileSize, URI actualLocation) {
        super(rdfResourceEntry.getResourceUrl(), "media_resource_", null);
        this.providedMimeType = Optional.ofNullable(providedMimeType).filter(type -> !type.startsWith(DEFAULT_MIME_TYPE)).orElse(null);
        this.providedFileSize = Optional.ofNullable(providedFileSize).orElse(DEFAULT_FILE_SIZE);
        this.urlTypes = new HashSet<UrlType>(rdfResourceEntry.getUrlTypes());
        this.actualLocation = actualLocation;
    }

    @Override
    public Path getContentPath() {
        return super.getContentPath();
    }

    @Override
    public Set<UrlType> getUrlTypes() {
        return Collections.unmodifiableSet(this.urlTypes);
    }

    @Override
    public String getProvidedMimeType() {
        return this.providedMimeType;
    }

    @Override
    public Long getProvidedFileSize() {
        return this.providedFileSize;
    }

    @Override
    public URI getActualLocation() {
        return this.actualLocation;
    }

    @Override
    public File getContentFile() {
        return Optional.ofNullable(this.getContentPath()).map(Path::toFile).orElse(null);
    }
}

