/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.model.UrlType;
import eu.europeana.metis.schema.jibx.Aggregation;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.schema.jibx.ResourceType;
import eu.europeana.metis.schema.jibx.WebResourceType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class RdfWrapper {
    private final RDF rdf;

    public RdfWrapper(RDF rdf) {
        this.rdf = rdf;
    }

    protected RDF getRdf() {
        return this.rdf;
    }

    Optional<String> getFirstResourceOfType(UrlType type) {
        return RdfWrapper.stream(this.rdf.getAggregationList()).flatMap(aggregation -> RdfWrapper.getLinksOfType(aggregation, type)).filter(Objects::nonNull).map(ResourceType::getResource).filter(StringUtils::isNotBlank).findFirst();
    }

    private static Stream<ResourceType> getLinksOfType(Aggregation aggregation, UrlType type) {
        Stream<ResourceType> result;
        switch (type) {
            case OBJECT: {
                result = Stream.of(aggregation.getObject());
                break;
            }
            case HAS_VIEW: {
                result = RdfWrapper.stream(aggregation.getHasViewList());
                break;
            }
            case IS_SHOWN_AT: {
                result = Stream.of(aggregation.getIsShownAt());
                break;
            }
            case IS_SHOWN_BY: {
                result = Stream.of(aggregation.getIsShownBy());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    Optional<WebResourceType> getWebResource(String resourceUrl) {
        return RdfWrapper.stream(this.rdf.getWebResourceList()).filter(webResource -> resourceUrl.equals(webResource.getAbout())).findAny();
    }

    private static <T> Stream<T> stream(List<? extends T> list) {
        return Optional.ofNullable(list).map(Collection::stream).orElseGet(Stream::empty).filter(Objects::nonNull).map(item -> item);
    }
}

