/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.MediaExtractor;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.AudioVideoProcessor;
import eu.europeana.metis.mediaprocessing.extraction.CommandExecutor;
import eu.europeana.metis.mediaprocessing.extraction.ImageProcessor;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.extraction.PdfToImageConverter;
import eu.europeana.metis.mediaprocessing.extraction.TextProcessor;
import eu.europeana.metis.mediaprocessing.extraction.ThumbnailGenerator;
import eu.europeana.metis.mediaprocessing.http.MimeTypeDetectHttpClient;
import eu.europeana.metis.mediaprocessing.http.ResourceDownloadClient;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResult;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import eu.europeana.metis.schema.model.MediaType;
import eu.europeana.metis.utils.SonarqubeNullcheckAvoidanceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaExtractorImpl
implements MediaExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaExtractorImpl.class);
    private static final Set<UrlType> URL_TYPES_FOR_FULL_PROCESSING = Collections.unmodifiableSet(EnumSet.of(UrlType.IS_SHOWN_BY, UrlType.HAS_VIEW, UrlType.OBJECT));
    private static final Set<UrlType> URL_TYPES_FOR_REDUCED_PROCESSING = Collections.singleton(UrlType.IS_SHOWN_AT);
    private final ResourceDownloadClient resourceDownloadClient;
    private final MimeTypeDetectHttpClient mimeTypeDetectHttpClient;
    private final Tika tika;
    private final ImageProcessor imageProcessor;
    private final AudioVideoProcessor audioVideoProcessor;
    private final TextProcessor textProcessor;

    MediaExtractorImpl(ResourceDownloadClient resourceDownloadClient, MimeTypeDetectHttpClient mimeTypeDetectHttpClient, Tika tika, ImageProcessor imageProcessor, AudioVideoProcessor audioVideoProcessor, TextProcessor textProcessor) {
        this.resourceDownloadClient = resourceDownloadClient;
        this.mimeTypeDetectHttpClient = mimeTypeDetectHttpClient;
        this.tika = tika;
        this.imageProcessor = imageProcessor;
        this.audioVideoProcessor = audioVideoProcessor;
        this.textProcessor = textProcessor;
    }

    public MediaExtractorImpl(int redirectCount, int thumbnailGenerateTimeout, int audioVideoProbeTimeout, int connectTimeout, int responseTimeout, int downloadTimeout) throws MediaProcessorException {
        ThumbnailGenerator thumbnailGenerator = new ThumbnailGenerator(new CommandExecutor(thumbnailGenerateTimeout));
        this.resourceDownloadClient = new ResourceDownloadClient(redirectCount, this::shouldDownloadForFullProcessing, connectTimeout, responseTimeout, downloadTimeout);
        this.mimeTypeDetectHttpClient = new MimeTypeDetectHttpClient(connectTimeout, responseTimeout, downloadTimeout);
        this.tika = new Tika();
        this.imageProcessor = new ImageProcessor(thumbnailGenerator);
        this.audioVideoProcessor = new AudioVideoProcessor(new CommandExecutor(audioVideoProbeTimeout));
        this.textProcessor = new TextProcessor(thumbnailGenerator, new PdfToImageConverter(new CommandExecutor(thumbnailGenerateTimeout)));
    }

    @Override
    public ResourceExtractionResult performMediaExtraction(RdfResourceEntry resourceEntry, boolean mainThumbnailAvailable) throws MediaExtractionException {
        ResourceExtractionResult resourceExtractionResult;
        block9: {
            ProcessingMode mode = this.getMode(resourceEntry);
            if (mode == ProcessingMode.NONE) {
                return null;
            }
            Resource resource = this.downloadBasedOnProcessingMode(resourceEntry, mode);
            try {
                resourceExtractionResult = this.performProcessing(resource, mode, mainThumbnailAvailable);
                if (resource == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new MediaExtractionException(String.format("Problem while processing %s", resourceEntry.getResourceUrl()), e);
                }
            }
            resource.close();
        }
        return resourceExtractionResult;
    }

    private Resource downloadBasedOnProcessingMode(RdfResourceEntry resourceEntry, ProcessingMode mode) throws IOException {
        return mode == ProcessingMode.FULL ? this.resourceDownloadClient.downloadBasedOnMimeType(resourceEntry) : this.resourceDownloadClient.downloadWithoutContent(resourceEntry);
    }

    ProcessingMode getMode(RdfResourceEntry resourceEntry) {
        ProcessingMode result = URL_TYPES_FOR_FULL_PROCESSING.stream().anyMatch(resourceEntry.getUrlTypes()::contains) ? ProcessingMode.FULL : (URL_TYPES_FOR_REDUCED_PROCESSING.stream().anyMatch(resourceEntry.getUrlTypes()::contains) ? ProcessingMode.REDUCED : ProcessingMode.NONE);
        return result;
    }

    String detectAndVerifyMimeType(Resource resource, ProcessingMode mode) throws MediaExtractionException {
        String detectedMimeType;
        if (mode == ProcessingMode.NONE) {
            throw new IllegalStateException();
        }
        String providedMimeType = resource.getProvidedMimeType();
        try {
            boolean hasContent = resource.hasContent();
            detectedMimeType = hasContent ? this.detectType(resource.getContentPath(), providedMimeType) : (String)this.mimeTypeDetectHttpClient.download(resource.getActualLocation().toURL());
        }
        catch (IOException e) {
            throw new MediaExtractionException("Mime type checking error", e);
        }
        if (providedMimeType != null) {
            boolean xhtmlHtmlEquivalenceOccurs;
            boolean bl = xhtmlHtmlEquivalenceOccurs = "application/xhtml+xml".equals(detectedMimeType) && providedMimeType.startsWith("text/html");
            if (!xhtmlHtmlEquivalenceOccurs && !detectedMimeType.equals(providedMimeType)) {
                LOGGER.info("Invalid mime type provided (should be {}, was {}): {}", detectedMimeType, providedMimeType, resource.getResourceUrl());
            }
        }
        return detectedMimeType;
    }

    String detectType(Path path, String providedMimeType) throws IOException {
        Metadata metadata = new Metadata();
        if (providedMimeType != null) {
            int separatorIndex = providedMimeType.indexOf(59);
            String adjustedMimeType = separatorIndex < 0 ? providedMimeType : providedMimeType.substring(0, separatorIndex);
            metadata.set("Content-Type", adjustedMimeType);
        }
        try (TikaInputStream stream = TikaInputStream.get(path, metadata);){
            String string = this.tika.detect((InputStream)stream, metadata);
            return string;
        }
    }

    MediaProcessor chooseMediaProcessor(MediaType mediaType) {
        MediaProcessor processor;
        switch (mediaType) {
            case TEXT: {
                processor = this.textProcessor;
                break;
            }
            case AUDIO: 
            case VIDEO: {
                processor = this.audioVideoProcessor;
                break;
            }
            case IMAGE: {
                processor = this.imageProcessor;
                break;
            }
            default: {
                processor = null;
            }
        }
        return processor;
    }

    void verifyAndCorrectContentAvailability(Resource resource, ProcessingMode mode, String detectedMimeType) throws MediaExtractionException, IOException {
        if (mode == ProcessingMode.FULL && this.shouldDownloadForFullProcessing(detectedMimeType) && !this.shouldDownloadForFullProcessing(resource.getProvidedMimeType())) {
            RdfResourceEntry downloadInput = new RdfResourceEntry(resource.getResourceUrl(), new ArrayList<UrlType>(resource.getUrlTypes()));
            SonarqubeNullcheckAvoidanceUtils.ThrowingConsumer action = resourceWithContent -> {
                if (resourceWithContent.hasContent()) {
                    try (InputStream inputStream = resourceWithContent.getContentStream();){
                        resource.markAsWithContent(inputStream);
                    }
                }
            };
            try (Resource resourceWithContent2 = this.resourceDownloadClient.downloadWithContent(downloadInput);){
                SonarqubeNullcheckAvoidanceUtils.performThrowingAction(resourceWithContent2, action);
            }
        }
        if (mode == ProcessingMode.FULL && this.shouldDownloadForFullProcessing(detectedMimeType) && !resource.hasContent()) {
            throw new MediaExtractionException("File content is not downloaded and mimeType does not support processing without a downloaded file.");
        }
    }

    ResourceExtractionResult performProcessing(Resource resource, ProcessingMode mode, boolean mainThumbnailAvailable) throws MediaExtractionException {
        if (mode == ProcessingMode.NONE) {
            throw new IllegalStateException();
        }
        String detectedMimeType = this.detectAndVerifyMimeType(resource, mode);
        try {
            this.verifyAndCorrectContentAvailability(resource, mode, detectedMimeType);
        }
        catch (IOException e) {
            throw new MediaExtractionException("Content availability verification error.", e);
        }
        MediaProcessor processor = this.chooseMediaProcessor(MediaType.getMediaType(detectedMimeType));
        ResourceExtractionResult result = processor == null ? null : (mode == ProcessingMode.FULL ? processor.extractMetadata(resource, detectedMimeType, mainThumbnailAvailable) : processor.copyMetadata(resource, detectedMimeType));
        return result;
    }

    @Override
    public void close() throws IOException {
        this.resourceDownloadClient.close();
    }

    boolean shouldDownloadForFullProcessing(String mimeType) {
        return Optional.of(MediaType.getMediaType(mimeType)).map(this::chooseMediaProcessor).map(MediaProcessor::downloadResourceForFullProcessing).orElse(Boolean.FALSE);
    }

    static enum ProcessingMode {
        FULL,
        REDUCED,
        NONE;

    }
}

