/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandExecutor.class);
    private final ProcessFactory processFactory;
    private final int commandTimeout;

    CommandExecutor(int commandTimeout) {
        this(commandTimeout, (command, redirectErrorStream) -> new ProcessBuilder(command).redirectErrorStream(redirectErrorStream).start());
    }

    CommandExecutor(int commandTimeout, ProcessFactory processFactory) {
        this.commandTimeout = commandTimeout;
        this.processFactory = processFactory;
    }

    <E extends Exception> String execute(List<String> command, boolean redirectErrorStream, Function<String, E> exceptionProducer) throws E {
        try {
            return this.executeInternal(command, redirectErrorStream, exceptionProducer);
        }
        catch (IOException | RuntimeException e) {
            Exception exceptionToThrow = (Exception)exceptionProducer.apply("Problem while executing command: " + e.getMessage());
            exceptionToThrow.initCause(e);
            throw exceptionToThrow;
        }
    }

    <E extends Exception> String executeInternal(List<String> command, boolean redirectErrorStream, Function<String, E> exceptionProducer) throws IOException, E {
        String error;
        Process process = this.processFactory.createProcess(command, redirectErrorStream);
        try {
            if (!process.waitFor(this.commandTimeout, TimeUnit.SECONDS)) {
                process.destroyForcibly();
                throw (Exception)exceptionProducer.apply("The process did not terminate within the timeout of " + this.commandTimeout + " seconds. It was forcibly destroyed.");
            }
        }
        catch (InterruptedException e) {
            process.destroyForcibly();
            Thread.currentThread().interrupt();
            Exception exceptionToThrow = (Exception)exceptionProducer.apply("Process was interrupted.");
            exceptionToThrow.initCause(e);
            throw exceptionToThrow;
        }
        if (redirectErrorStream) {
            error = null;
        } else {
            try (InputStream errorStream = process.getErrorStream();){
                String errorStreamContents = IOUtils.toString(errorStream, Charset.defaultCharset());
                error = StringUtils.isBlank(errorStreamContents) ? null : errorStreamContents;
            }
        }
        if (error != null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Command presented with error:\nCommand: [{}]\nError: {}", (Object)String.join((CharSequence)" ", command), (Object)error);
            }
            throw (Exception)exceptionProducer.apply("External process returned error content:\n" + error);
        }
        try (InputStream in = process.getInputStream();){
            String string = IOUtils.toString(in, Charset.defaultCharset());
            return string;
        }
    }

    public static interface ProcessFactory {
        public Process createProcess(List<String> var1, boolean var2) throws IOException;
    }
}

